/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns;

import de.riwagis.riwadatatable.columns.ColumnFactory;
import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.GeometryColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.curved.RiwaCurvedGeometryFactory;
import de.riwagis.riwadatatable.columns.defaultvalues.DefaultValue;
import de.riwagis.riwadatatable.columns.util.WKBReader2;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.validation.ValidationError;
import de.riwagis.riwadatatable.validation.ValidationErrorType;
import de.riwagis.util.exception.SystemException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.geotools.geometry.jts.CurvedGeometries;
import org.geotools.geometry.jts.CurvedGeometry;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTWriter;

public class MSSQLServerGeometryColumn
extends GeometryColumn {
    private static final double DEFAULT_TOLERANCE = 0.01;

    private MSSQLServerGeometryColumn(String _strTableName, String strColumnName, int _intNullable, DefaultValue _defaultValue, JDBCConnectionInfo _connInfo) {
        super(_strTableName, strColumnName, _intNullable, _defaultValue, _connInfo);
        this.setSelectColName(strColumnName + ".STAsBinary() as " + strColumnName);
    }

    @Override
    public TableColumn cloneColumn(JDBCConnectionManager connMngr) {
        return this.overtakeNotFinalColumnAttributes(new MSSQLServerGeometryColumn(this.getTableName(), this.getColumnName(), this.getNullable(), this.cloneDefaultValue(connMngr), connMngr.getConnectionInfo()));
    }

    private int getSrid4SQLServer() {
        int srid = this.getConnectionInfo().getSRID();
        if (srid == -1) {
            srid = 0;
        }
        return srid;
    }

    @Override
    public String getInsertString() {
        return "geometry::STGeomFromWKB(?," + this.getSrid4SQLServer() + ")";
    }

    @Override
    public String getUpdateString() {
        return "geometry::STGeomFromWKB(?," + this.getSrid4SQLServer() + ")";
    }

    @Override
    public Object getObject(int index, ResultSet rs) throws SystemException {
        try {
            Object obj = rs.getObject(index);
            if (obj != null) {
                return this.getGeometry(obj);
            }
            return obj;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public void setString(int index, String str, PreparedStatement stmt) throws SystemException {
        try {
            Object obj = this.getDBGeometry(stmt, (Geometry)this.parseObject(str));
            stmt.setObject(index, obj, 1111);
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public void setObject(int index, Object obj, PreparedStatement stmt) throws SystemException {
        try {
            if (obj == null) {
                stmt.setNull(index, 1111);
            }
            if (obj instanceof Geometry) {
                obj = this.getDBGeometry(stmt, (Geometry)obj);
            }
            stmt.setBytes(index, (byte[])obj);
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            return "";
        }
        try {
            if (obj instanceof Geometry) {
                WKTWriter writer = new WKTWriter();
                return writer.write((Geometry)obj);
            }
            if (obj instanceof byte[]) {
                Geometry geom = this.getGeometry(obj);
                return this.format(geom);
            }
            throw new Exception("format(): invalid object.");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public ColumnTypes getType() {
        return ColumnTypes.CT_MSSQLSERVERGEOMETRY_COLUMN;
    }

    @Override
    public Geometry getGeometry(Object obj) throws SystemException {
        try {
            if (obj instanceof Geometry) {
                return (Geometry)obj;
            }
            WKBReader2 reader = new WKBReader2((GeometryFactory)new RiwaCurvedGeometryFactory(0.01));
            Geometry geom = reader.read((byte[])obj);
            if (CurvedGeometries.isCurved((Geometry)geom)) {
                return ((CurvedGeometry)geom).linearize(0.01);
            }
            return geom;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public Object getDBGeometry(PreparedStatement pstmt, Geometry geom) throws SystemException {
        try {
            WKBWriter writer = new WKBWriter();
            byte[] arrbyte = writer.write(geom);
            return arrbyte;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public String getEnvelopeString() {
        return this.getColumnName() + ".STEnvelope().STAsBinary() as " + this.getColumnName();
    }

    @Override
    public String getIntersectsString(String geom1, String geom2) {
        return String.format("%s.STIntersects(%s) = 1", geom1, geom2);
    }

    @Override
    public String getContainsString(String geom1, String geom2) {
        return String.format("%s.STContains(%s) = 1", geom1, geom2);
    }

    @Override
    public String getOverlapsString(String geom1, String geom2) {
        return String.format("%s.STOverlaps(%s) = 1", geom1, geom2);
    }

    @Override
    public String getTouchesString(String geom1, String geom2) {
        return String.format("%s.STTouches(%s) = 1", geom1, geom2);
    }

    @Override
    protected ValidationError validateDataObject(Object data) {
        ValidationError error = super.validateDataObject(data);
        if (error != null) {
            return error;
        }
        if (data != null && !(data instanceof Geometry) && !(data instanceof byte[])) {
            return this.validationError4Message(String.format("Datenfeld '%s'. Ung\u00fcltige Objektart '%s' f\u00fcr Zahl  \u00fcbergeben.", this.getColumnNameExternal(), data.getClass().getCanonicalName()), ValidationErrorType.INVALID_DATA_TYPE, null);
        }
        return null;
    }

    static {
        ColumnFactory.addFactory(ColumnTypes.CT_MSSQLSERVERGEOMETRY_COLUMN, new ColumnFactory(){

            @Override
            protected TableColumn create(String strTableName, String strColumnName, int sqlType, String strSqlTypename, int intColumnSize, int intNullable, DefaultValue defaultValue, JDBCConnectionInfo connInfo) throws SystemException {
                try {
                    MSSQLServerGeometryColumn colGeom = new MSSQLServerGeometryColumn(strTableName, strColumnName, intNullable, defaultValue, connInfo);
                    return colGeom;
                }
                catch (Exception e) {
                    throw new SystemException(MSSQLServerGeometryColumn.class, "create():", (Throwable)e);
                }
            }

            @Override
            protected boolean isFactoryFor(int intSqlType, String strSqlTypename, JDBCConnectionInfo connInfo) {
                return connInfo.isMSSQLServer() && strSqlTypename.equalsIgnoreCase("geometry");
            }
        });
    }
}

