/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns;

import de.riwagis.riwadatatable.columns.AbstractColumn;
import de.riwagis.riwadatatable.columns.GeoColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.defaultvalues.DefaultValue;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.lang.StringComparator;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.geotools.feature.AttributeTypeBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeometryColumn
extends AbstractColumn
implements GeoColumn {
    private static final Logger LOG = LoggerFactory.getLogger(GeometryColumn.class);
    private String strSelectColName;
    private Object objectValue;

    public GeometryColumn(String _strTableName, String _strColumnName, int _intNullable, DefaultValue _defaultValue, JDBCConnectionInfo _connInfo) {
        super(_strTableName, _strColumnName, -1, _intNullable, _defaultValue, _connInfo);
        this.strSelectColName = _strColumnName;
        this.setColumnNameExternal(_strColumnName);
    }

    @Override
    protected TableColumn overtakeNotFinalColumnAttributes(TableColumn clonedColumn) {
        super.overtakeNotFinalColumnAttributes(clonedColumn);
        ((GeometryColumn)clonedColumn).setSelectColName(this.getSelectColName());
        return clonedColumn;
    }

    @Override
    public String getColumnTypeString() {
        return "geometry";
    }

    @Override
    public char getColumnQuote() {
        return ' ';
    }

    @Override
    public String toString() {
        return this.getColumnName();
    }

    @Override
    public String getSelectString() {
        return this.strSelectColName;
    }

    @Override
    public String getInsertString() {
        return "?";
    }

    @Override
    public String getUpdateString() {
        return "?";
    }

    @Override
    public Object parseObject(String source) throws SystemException {
        try {
            if (StringUtils.isEmpty((String)source)) {
                return null;
            }
            WKTReader read = new WKTReader();
            return read.read(source);
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public void setStringValue(String strValue) {
        WKTReader reader = new WKTReader();
        try {
            this.objectValue = reader.read(StringUtils.defaultString((String)strValue));
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    @Override
    public String getStringValue() {
        if (this.objectValue == null) {
            return "";
        }
        if (this.objectValue instanceof String) {
            return (String)this.objectValue;
        }
        return this.format(this.objectValue);
    }

    @Override
    public void setObjectValue(Object objValue) {
        this.objectValue = objValue;
    }

    @Override
    public Object getObjectValue() {
        return this.objectValue;
    }

    @Override
    public Comparator<Object> getColumnValueComparator() {
        return new Comparator<Object>(){
            private final Comparator<Object> strComp = new StringComparator();

            @Override
            public int compare(Object o1, Object o2) {
                String str1 = GeometryColumn.this.format(o1);
                String str2 = GeometryColumn.this.format(o2);
                return this.strComp.compare(str1, str2);
            }
        };
    }

    public final String getSelectColName() {
        return this.strSelectColName;
    }

    public final void setSelectColName(String strSelectColName) {
        this.strSelectColName = strSelectColName;
    }

    @Override
    public AttributeDescriptor buildDescriptor(AttributeTypeBuilder attBuilder) {
        this.adjustTypeBuilder(attBuilder);
        attBuilder.setBinding(Geometry.class);
        if (this.getConnectionInfo().getCRS() != null) {
            try {
                CoordinateReferenceSystem crs = this.getConnectionInfo().getCRS().getCRS();
                attBuilder.setCRS(crs);
            }
            catch (Exception ex) {
                LOG.warn("could not create CRS '" + this.getConnectionInfo().getCRS().getCode() + "' for Geometry Column " + this.getColumnName(), (Throwable)ex);
            }
        }
        return attBuilder.buildDescriptor(this.getColumnName(), attBuilder.buildGeometryType());
    }
}

