/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns;

import de.riwagis.riwadatatable.columns.AbstractDateColumn;
import de.riwagis.riwadatatable.columns.ColumnFactory;
import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.Formatable;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.defaultvalues.DefaultValue;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.jdbc.JDBCSupport;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class DateColumn
extends AbstractDateColumn
implements Formatable {
    private static final DateFormat DEFAULT_FORMAT = SimpleDateFormat.getDateInstance(2, Config.LOCALE);
    private static final DateFormat DEFAULT_PARSER = SimpleDateFormat.getDateInstance(3, Config.LOCALE);
    private static final DateFormat DEFAULT_FORMAT_TIMESTAMP = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final DateFormat DEFAULT_PARSER_TIMESTAMP = new SimpleDateFormat("dd.MM.yy HH:mm:ss");

    private DateColumn(String strTableName, String strColumnName, int intColumnSize, int intNullable, DefaultValue defaultValue, boolean datetime, JDBCConnectionInfo connInfo) {
        super(strTableName, strColumnName, intColumnSize, intNullable, defaultValue, connInfo);
        if (datetime) {
            this.fmtColumnFormatter = DEFAULT_FORMAT_TIMESTAMP;
            this.fmtColumnParser = DEFAULT_PARSER_TIMESTAMP;
        } else {
            this.fmtColumnFormatter = DEFAULT_FORMAT;
            this.fmtColumnParser = DEFAULT_PARSER;
        }
        this.setDateTime(datetime);
    }

    @Override
    public TableColumn cloneColumn(JDBCConnectionManager connMngr) {
        return this.overtakeNotFinalColumnAttributes(new DateColumn(this.getTableName(), this.getColumnName(), this.getColumnSize(), this.getNullable(), this.cloneDefaultValue(connMngr), this.isDateTime(), connMngr.getConnectionInfo()));
    }

    @Override
    public final void setDateTime(boolean datetime) {
        super.setDateTime(datetime);
        if (datetime) {
            if (DEFAULT_FORMAT.equals(this.fmtColumnFormatter)) {
                this.fmtColumnFormatter = DEFAULT_FORMAT_TIMESTAMP;
            }
            if (DEFAULT_PARSER.equals(this.fmtColumnParser)) {
                this.fmtColumnParser = DEFAULT_PARSER_TIMESTAMP;
            }
        } else {
            if (DEFAULT_FORMAT_TIMESTAMP.equals(this.fmtColumnFormatter)) {
                this.fmtColumnFormatter = DEFAULT_FORMAT;
            }
            if (DEFAULT_PARSER_TIMESTAMP.equals(this.fmtColumnParser)) {
                this.fmtColumnParser = DEFAULT_PARSER;
            }
        }
    }

    @Override
    public Object getObject(int index, ResultSet rs) throws SystemException {
        try {
            if (this.isDateTime()) {
                return rs.getTimestamp(index);
            }
            return rs.getDate(index);
        }
        catch (Exception e) {
            SQLException sqlEx;
            if ((this.getConnectionInfo().isMySQL() || this.getConnectionInfo().isMariaDB()) && e instanceof SQLException && "S1009".equals((sqlEx = (SQLException)e).getSQLState()) && (sqlEx.getMessage().contains("0000") || StringUtils.containsIgnoreCase((String)sqlEx.getMessage(), (String)"zero date"))) {
                return null;
            }
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public void setString(int index, String str, PreparedStatement stmt) throws SystemException {
        try {
            Object obj = this.parseObject(str);
            if (this.isDateTime()) {
                stmt.setObject(index, obj, 93);
            } else {
                stmt.setObject(index, obj, 91);
            }
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    @Override
    public void setObject(int index, Object obj, PreparedStatement stmt) throws SystemException {
        try {
            if (this.isDateTime()) {
                Timestamp sqlDate = null;
                if (obj != null) {
                    sqlDate = new Timestamp(((java.util.Date)obj).getTime());
                }
                stmt.setTimestamp(index, sqlDate);
            } else {
                Date sqlDate = null;
                if (obj != null) {
                    sqlDate = new Date(((java.util.Date)obj).getTime());
                }
                stmt.setDate(index, sqlDate);
            }
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(Object obj) {
        if (StringUtils.isBlank((String)ObjectUtils.toString((Object)obj))) {
            return "";
        }
        if (this.fmtColumnFormatter == null) {
            return obj.toString();
        }
        DateFormat dateFormat = this.fmtColumnFormatter;
        synchronized (dateFormat) {
            return this.fmtColumnFormatter.format(obj);
        }
    }

    @Override
    public String getColumnTypeString() {
        if (this.isDateTime()) {
            return "datetime";
        }
        return "date";
    }

    static {
        DEFAULT_PARSER.setLenient(true);
        DEFAULT_PARSER_TIMESTAMP.setLenient(true);
        ColumnFactory.addFactory(ColumnTypes.CT_DATE_COLUMN, new ColumnFactory(){

            @Override
            protected TableColumn create(String strTableName, String strColumnName, int intSQLType, String strSqlTypename, int intColumnSize, int intNullable, DefaultValue defaultValue, JDBCConnectionInfo connInfo) throws SystemException {
                try {
                    boolean datetime = JDBCSupport.isDateTimeColumn((int)intSQLType);
                    if (connInfo != null && connInfo.isOracle() && (strSqlTypename.equals("DATE") || strSqlTypename.equals("java.sql.Date"))) {
                        datetime = false;
                    }
                    return new DateColumn(strTableName, strColumnName, -1, intNullable, defaultValue, datetime, connInfo);
                }
                catch (Exception e) {
                    throw new SystemException(DateColumn.class, "create():", (Throwable)e);
                }
            }

            @Override
            protected boolean isFactoryFor(int intSqlType, String strSqlTypename, JDBCConnectionInfo connInfo) {
                return JDBCSupport.isDateColumn((int)intSqlType) || JDBCSupport.isDateTimeColumn((int)intSqlType);
            }
        });
    }
}

