/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns;

import de.riwagis.dbparser.data.Column;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;

public class ColumnUtils {
    private ColumnUtils() {
    }

    public static final TableColumn[] makeUniqueColumns(TableColumn[] columns) {
        Collection<TableColumn> columnsUQ = ColumnUtils.makeUniqueColumns(Arrays.asList(columns));
        return columnsUQ.toArray(new TableColumn[columnsUQ.size()]);
    }

    public static final Collection<TableColumn> makeUniqueColumns(Collection<TableColumn> columns) {
        LinkedHashMap<String, TableColumn> mapUniqueColumns = new LinkedHashMap<String, TableColumn>();
        for (TableColumn col : columns) {
            String columnNameLC = col.getColumnName().toLowerCase();
            mapUniqueColumns.put(columnNameLC, col);
        }
        return mapUniqueColumns.values();
    }

    public static final Collection<String> listColumnNames(Collection<TableColumn> columns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (TableColumn col : columns) {
            columnNames.add(col.getColumnName());
        }
        return columnNames;
    }

    public static final Collection<String> listColumnSelectStrings(Collection<TableColumn> columns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (TableColumn col : columns) {
            columnNames.add(col.getSelectString());
        }
        return columnNames;
    }

    public static final Collection<TableColumn> convertColumns2TableColumns(Collection<Column> columns) {
        ArrayList<TableColumn> tblColumns = new ArrayList<TableColumn>();
        for (Column col : columns) {
            tblColumns.add((TableColumn)col);
        }
        return tblColumns;
    }

    public static final TableColumn[] cloneColumns(JDBCConnectionManager connMngr, TableColumn[] columns2Clone) {
        TableColumn[] clonedColumns = new TableColumn[columns2Clone.length];
        for (int i = 0; i < columns2Clone.length; ++i) {
            clonedColumns[i] = columns2Clone[i].cloneColumn(connMngr);
        }
        return clonedColumns;
    }
}

