/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns;

import de.riwagis.riwadatatable.columns.ColumnFactoryCache;
import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.NumberColumn;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.defaultvalues.ConstantDefaultValue;
import de.riwagis.riwadatatable.columns.defaultvalues.DefaultValue;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.table.DbTableNameConvention;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.jdbc.JDBCSupport;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ColumnFactory {
    private static final Set<String> UNSIGNED_TYPES = new LinkedHashSet<String>();
    private static final Logger LOG = LoggerFactory.getLogger(ColumnFactory.class);
    private static final Map<String, ColumnFactory> KNOWN_FACTORIES = new LinkedHashMap<String, ColumnFactory>();
    private static ColumnFactoryCache columnCache = null;

    public static void registerColumnCache(ColumnFactoryCache columnCache) {
        ColumnFactory.columnCache = columnCache;
        if (columnCache != null) {
            LOG.info(String.format("Column cache '%s' registered for ColumnFactory.", columnCache.getClass().getName()));
        }
    }

    protected abstract boolean isFactoryFor(int var1, String var2, JDBCConnectionInfo var3);

    protected abstract TableColumn create(String var1, String var2, int var3, String var4, int var5, int var6, DefaultValue var7, JDBCConnectionInfo var8) throws SystemException;

    public static final void addFactory(ColumnTypes columnType, ColumnFactory factory) {
        if (!KNOWN_FACTORIES.containsKey(columnType.getClassname())) {
            KNOWN_FACTORIES.put(columnType.getClassname(), factory);
        }
    }

    private static ColumnFactory getFactory(int intSqlType, String strSqlTypename, JDBCConnectionInfo connInfo) {
        for (ColumnFactory currFactory : KNOWN_FACTORIES.values()) {
            if (!currFactory.isFactoryFor(intSqlType, strSqlTypename, connInfo)) continue;
            return currFactory;
        }
        return null;
    }

    public static TableColumn createColumn(int intSqlType, String strSqlTypename, String strTableName, String strColumnName, int intColumnSize, int intNullable, DefaultValue defaultValue, JDBCConnectionInfo connInfo) throws SystemException {
        try {
            ColumnFactory fac = ColumnFactory.getFactory(intSqlType, strSqlTypename, connInfo);
            if (fac == null) {
                LOG.debug(String.format("Unable to create column for '%s.%s' (type: %s/%d)", strTableName, strColumnName, strSqlTypename, intSqlType));
                return null;
            }
            return fac.create(strTableName, strColumnName, intSqlType, strSqlTypename, intColumnSize, intNullable, defaultValue, connInfo);
        }
        catch (Exception e) {
            throw new SystemException(ColumnFactory.class, String.format("Unable to create column for '%s.%s' (type: %s/%d): %s", strTableName, strColumnName, strSqlTypename, intSqlType, e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableColumn[] createColumns4Table(JDBCConnectionManager connMngr, String tableName, DbTableNameConvention dbTableNameConvention) throws SQLException, SystemException {
        TableColumn[] cachedColumnClones;
        if (columnCache != null && (cachedColumnClones = columnCache.retrieveCachedColumnClones(connMngr, tableName, dbTableNameConvention)) != null) {
            return cachedColumnClones;
        }
        Connection conn = connMngr.createConnection();
        JDBCConnectionInfo connInfo = connMngr.getConnectionInfo();
        if (columnCache != null) {
            connInfo = columnCache.createConnectionInfoForCache(connInfo);
        }
        ArrayList<TableColumn> lstColumns = new ArrayList<TableColumn>();
        try {
            DatabaseMetaData dbm = conn.getMetaData();
            if (!tableName.toLowerCase().contains("select ")) {
                String strTableScheme = connInfo.getScheme();
                String strTableCatalog = connInfo.getCatalog();
                ResultSet rsPkData = dbm.getPrimaryKeys(strTableCatalog, strTableScheme, tableName);
                ResultSet rsColumnData = dbm.getColumns(strTableCatalog, strTableScheme, tableName, null);
                if (!rsColumnData.isBeforeFirst() && connInfo.isOracle()) {
                    String strUpperTableScheme = strTableScheme.toUpperCase();
                    String strUpperTableName = tableName.toUpperCase();
                    rsColumnData.close();
                    rsPkData.close();
                    rsPkData = dbm.getPrimaryKeys(null, strUpperTableScheme, strUpperTableName);
                    rsColumnData = dbm.getColumns(null, strUpperTableScheme, strUpperTableName, null);
                    if (!rsColumnData.isBeforeFirst()) {
                        rsColumnData.close();
                        rsPkData.close();
                        rsPkData = dbm.getPrimaryKeys(null, strTableScheme, strUpperTableName);
                        rsColumnData = dbm.getColumns(null, strTableScheme, strUpperTableName, null);
                    }
                    if (!rsColumnData.isBeforeFirst()) {
                        rsColumnData.close();
                        rsPkData.close();
                        rsPkData = dbm.getPrimaryKeys(null, strUpperTableScheme, tableName);
                        rsColumnData = dbm.getColumns(null, strUpperTableScheme, tableName, null);
                    }
                }
                try {
                    while (rsColumnData.next()) {
                        String columnName = dbTableNameConvention.convertName(rsColumnData.getString("COLUMN_NAME"));
                        int intColSize = JDBCSupport.isTextColumn((int)rsColumnData.getInt("DATA_TYPE")) ? rsColumnData.getInt("COLUMN_SIZE") : -1;
                        int nullable = rsColumnData.getInt("NULLABLE");
                        boolean isAutoIncrement = false;
                        try {
                            String isAutoincrementStr = rsColumnData.getString("IS_AUTOINCREMENT");
                            if (ObjectUtils.toString((Object)isAutoincrementStr).equalsIgnoreCase("YES")) {
                                nullable = 1;
                                isAutoIncrement = true;
                            }
                        }
                        catch (SQLException sqlex) {
                            LOG.trace(String.format("unable to get isAutoincrement status on column %s.%s: %s", tableName, columnName, sqlex.getMessage()));
                        }
                        String defaultValueFromDB = ObjectUtils.toString((Object)rsColumnData.getString("COLUMN_DEF"));
                        if (defaultValueFromDB.length() > 0) {
                            nullable = 1;
                            if (connInfo.isOracle()) {
                                if (defaultValueFromDB.equalsIgnoreCase("null") || defaultValueFromDB.equalsIgnoreCase("sysdate") || defaultValueFromDB.equalsIgnoreCase("user")) {
                                    defaultValueFromDB = "";
                                }
                                if (defaultValueFromDB.trim().startsWith("(") && defaultValueFromDB.trim().endsWith(")")) {
                                    defaultValueFromDB = defaultValueFromDB.trim();
                                    defaultValueFromDB = defaultValueFromDB.substring(1);
                                    defaultValueFromDB = defaultValueFromDB.substring(0, defaultValueFromDB.length() - 1);
                                }
                                if (defaultValueFromDB.trim().startsWith("'") && defaultValueFromDB.trim().endsWith("'")) {
                                    defaultValueFromDB = defaultValueFromDB.trim();
                                    defaultValueFromDB = defaultValueFromDB.substring(1);
                                    defaultValueFromDB = defaultValueFromDB.substring(0, defaultValueFromDB.length() - 1);
                                }
                            } else if (connInfo.isPostgres()) {
                                if (defaultValueFromDB.startsWith("nextval('")) {
                                    defaultValueFromDB = "";
                                }
                                if (defaultValueFromDB.trim().startsWith("'")) {
                                    int sepIndex = defaultValueFromDB.indexOf("::");
                                    if (sepIndex > -1) {
                                        defaultValueFromDB = defaultValueFromDB.substring(0, sepIndex);
                                    }
                                    if (defaultValueFromDB.trim().endsWith("'")) {
                                        defaultValueFromDB = defaultValueFromDB.trim();
                                        defaultValueFromDB = defaultValueFromDB.substring(1);
                                        defaultValueFromDB = defaultValueFromDB.substring(0, defaultValueFromDB.length() - 1);
                                    }
                                }
                            } else if (connInfo.isMSSQLServer()) {
                                while (defaultValueFromDB.trim().startsWith("(") && defaultValueFromDB.endsWith(")")) {
                                    defaultValueFromDB = defaultValueFromDB.trim();
                                    defaultValueFromDB = defaultValueFromDB.substring(1);
                                    defaultValueFromDB = defaultValueFromDB.substring(0, defaultValueFromDB.length() - 1);
                                }
                                if (defaultValueFromDB.trim().startsWith("'") && defaultValueFromDB.trim().endsWith("'")) {
                                    defaultValueFromDB = defaultValueFromDB.trim();
                                    defaultValueFromDB = defaultValueFromDB.substring(1);
                                    defaultValueFromDB = defaultValueFromDB.substring(0, defaultValueFromDB.length() - 1);
                                }
                            }
                        }
                        TableColumn col = ColumnFactory.createColumn(rsColumnData.getInt("DATA_TYPE"), rsColumnData.getString("TYPE_NAME"), tableName, columnName, intColSize, nullable, null, connInfo);
                        if (StringUtils.isNotBlank((String)defaultValueFromDB)) {
                            ConstantDefaultValue defaultValue = new ConstantDefaultValue(defaultValueFromDB);
                            try {
                                defaultValue.getDefaultValue(col);
                                col.setDefaultValue(defaultValue);
                            }
                            catch (Throwable t) {
                                LOG.debug(String.format("Default value '%s' for column '%s' in table '%s' ignored. Value could not be parsed: %s", defaultValueFromDB, col.getColumnName(), tableName, t.getMessage()), t);
                            }
                        }
                        if (col == null) continue;
                        if (col instanceof NumberColumn) {
                            ((NumberColumn)col).setAutoIncrement(isAutoIncrement);
                            ResultSet tirs = dbm.getTypeInfo();
                            try {
                                while (tirs.next()) {
                                    if (!StringUtils.equalsIgnoreCase((String)tirs.getString("TYPE_NAME"), (String)rsColumnData.getString("TYPE_NAME")) || !UNSIGNED_TYPES.contains(tirs.getString("TYPE_NAME"))) continue;
                                    col.setUnsigned(true);
                                }
                            }
                            finally {
                                DbUtils.closeQuietly((ResultSet)tirs);
                            }
                        }
                        lstColumns.add(col);
                    }
                    block22: while (rsPkData.next()) {
                        String pkColumnName = dbTableNameConvention.convertName(rsPkData.getString("COLUMN_NAME"));
                        short pkKeySEQ = rsPkData.getShort("KEY_SEQ");
                        for (TableColumn col : lstColumns) {
                            if (!col.getColumnName().equalsIgnoreCase(pkColumnName)) continue;
                            col.setPrimaryKeyIndex(pkKeySEQ);
                            continue block22;
                        }
                    }
                }
                finally {
                    DbUtils.closeQuietly((ResultSet)rsColumnData);
                    DbUtils.closeQuietly((ResultSet)rsPkData);
                }
            }
            if (lstColumns.isEmpty()) {
                Statement stmtReadTblData = conn.createStatement();
                try {
                    stmtReadTblData.setFetchSize(1);
                    ResultSet rsReadTblData = stmtReadTblData.executeQuery("select * from " + tableName + " tbl where 1=0");
                    try {
                        ResultSetMetaData rsm = rsReadTblData.getMetaData();
                        for (int i = 1; i <= rsm.getColumnCount(); ++i) {
                            TableColumn colTmp;
                            String strTmpColname = dbTableNameConvention.convertName(rsm.getColumnLabel(i));
                            int intTmpColtype = rsm.getColumnType(i);
                            String strTmpColtypeName = rsm.getColumnTypeName(i);
                            int intColSize = -1;
                            if (JDBCSupport.isTextColumn((int)intTmpColtype)) {
                                intColSize = rsm.getColumnDisplaySize(i);
                            }
                            if ((colTmp = ColumnFactory.createColumn(intTmpColtype, strTmpColtypeName, tableName, strTmpColname, intColSize, 1, null, connInfo)) == null) continue;
                            lstColumns.add(colTmp);
                        }
                    }
                    finally {
                        DbUtils.closeQuietly((ResultSet)rsReadTblData);
                    }
                }
                finally {
                    DbUtils.closeQuietly((Statement)stmtReadTblData);
                }
            }
            TableColumn[] columns = lstColumns.toArray(new TableColumn[lstColumns.size()]);
            if (columnCache != null) {
                columns = columnCache.addColumnsToCache(connMngr, tableName, dbTableNameConvention, columns);
            }
            TableColumn[] tableColumnArray = columns;
            return tableColumnArray;
        }
        finally {
            connMngr.closeConnection(conn);
        }
    }

    static {
        UNSIGNED_TYPES.add("INTEGER UNSIGNED");
        UNSIGNED_TYPES.add("INT UNSIGNED");
        UNSIGNED_TYPES.add("MEDIUMINT UNSIGNED");
        UNSIGNED_TYPES.add("SMALLINT UNSIGNED");
        UNSIGNED_TYPES.add("TINYINT UNSIGNED");
        UNSIGNED_TYPES.add("BIGINT UNSIGNED");
        for (ColumnTypes currColumnType : ColumnTypes.values()) {
            try {
                Class<?> columnClass = Class.forName("de.riwagis.riwadatatable.columns." + currColumnType.getClassname());
                LOG.debug(String.format("Supported Column '%s' loaded: %s", new Object[]{currColumnType, columnClass.getCanonicalName()}));
            }
            catch (ClassNotFoundException e) {
                LOG.warn(String.format("Error in ColumnFactory - '%s' not found: %s", new Object[]{currColumnType, e.getMessage()}));
            }
        }
    }
}

