/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns;

import de.riwagis.riwadatatable.columns.AbstractColumn;
import de.riwagis.riwadatatable.columns.ColumnTypes;
import de.riwagis.riwadatatable.columns.DateColumn;
import de.riwagis.riwadatatable.columns.Formatable;
import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.defaultvalues.DefaultValue;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.table.extension.presetvalues.DbTableDefaultPresetColumns;
import de.riwagis.riwadatatable.validation.ValidationError;
import de.riwagis.riwadatatable.validation.ValidationErrorType;
import de.riwagis.util.Config;
import de.riwagis.util.StringSupport;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.lang.DateComparator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.feature.AttributeTypeBuilder;
import org.opengis.feature.type.AttributeDescriptor;

public abstract class AbstractDateColumn
extends AbstractColumn
implements Formatable {
    private static final DateFormat DEFAULT_FORMAT = SimpleDateFormat.getDateInstance(2, Config.LOCALE);
    private static final DateFormat DEFAULT_PARSER = SimpleDateFormat.getDateInstance(3, Config.LOCALE);
    private boolean datetime = false;
    private Object ObjectValue = "";
    protected DateFormat fmtColumnFormatter = null;
    protected DateFormat fmtColumnParser = null;
    private static final DateFormat fmtMySQLDateTimeFormatter;
    private static final DateFormat fmtMySQLDateFormatter;

    protected AbstractDateColumn(String _strTableName, String _strColumnName, int _intColumnSize, int _intNullable, DefaultValue _defaultValue, JDBCConnectionInfo _connInfo) {
        super(_strTableName, _strColumnName, _intColumnSize, _intNullable, _defaultValue, _connInfo);
        this.setColumnNameExternal(_strColumnName);
    }

    @Override
    protected TableColumn overtakeNotFinalColumnAttributes(TableColumn clonedColumn) {
        super.overtakeNotFinalColumnAttributes(clonedColumn);
        ((AbstractDateColumn)clonedColumn).fmtColumnFormatter = (DateFormat)this.fmtColumnFormatter.clone();
        ((AbstractDateColumn)clonedColumn).fmtColumnParser = (DateFormat)this.fmtColumnParser.clone();
        return clonedColumn;
    }

    @Override
    public String toString() {
        return this.getColumnName();
    }

    @Override
    public String getInsertString() {
        return "?";
    }

    @Override
    public String getUpdateString() {
        return "?";
    }

    public String getWhereColumnString() {
        return this.getWhereColumnString(this.getColumnName());
    }

    public String getWhereColumnString(String columnName) {
        if (!this.isDateTime() && this.getConnectionInfo() != null && this.getConnectionInfo().isOracle()) {
            return "TRUNC(" + columnName + ")";
        }
        return columnName;
    }

    public DateFormat getDateFormatInternal() {
        return this.fmtColumnFormatter;
    }

    @Override
    public Object parseObject(String source) throws SystemException {
        try {
            return AbstractDateColumn.parseObject(StringUtils.trim((String)StringUtils.normalizeSpace((String)source)), this.fmtColumnFormatter, this.fmtColumnParser);
        }
        catch (SystemException pe) {
            if (this.isDateTime()) {
                try {
                    return AbstractDateColumn.parseObject(StringUtils.trim((String)StringUtils.normalizeSpace((String)source)), DEFAULT_FORMAT, DEFAULT_PARSER);
                }
                catch (SystemException t) {
                    throw pe;
                }
            }
            throw pe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseObject(String source, DateFormat fmtColumnFormatter, DateFormat fmtColumnParser) throws SystemException {
        try {
            if (StringUtils.isBlank((String)source)) {
                return null;
            }
            DateFormat dateFormat = fmtColumnFormatter;
            synchronized (dateFormat) {
                source = StringSupport.shortDate2Date((String)source, (boolean)true, (DateFormat)fmtColumnFormatter);
            }
            if (fmtColumnParser == null) {
                if (fmtColumnFormatter == null) {
                    return source;
                }
                dateFormat = fmtColumnFormatter;
                synchronized (dateFormat) {
                    return fmtColumnFormatter.parseObject(source);
                }
            }
            dateFormat = fmtColumnParser;
            synchronized (dateFormat) {
                return fmtColumnParser.parseObject(source);
            }
        }
        catch (Exception e) {
            throw new SystemException(AbstractDateColumn.class, String.format("Unable to parse date '%s': %s", source, e.getMessage()), (Throwable)e);
        }
    }

    public static boolean isDateColumn(TableColumn column) {
        boolean isDateColumn = column instanceof DateColumn ? !((AbstractDateColumn)column).isDateTime() : false;
        return isDateColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(Object obj) {
        if (StringUtils.isBlank((String)ObjectUtils.toString((Object)obj))) {
            return "";
        }
        if (this.fmtColumnFormatter == null) {
            return obj.toString();
        }
        DateFormat dateFormat = this.fmtColumnFormatter;
        synchronized (dateFormat) {
            return this.fmtColumnFormatter.format(obj);
        }
    }

    protected void setFormat(DateFormat columnFormatter) throws SystemException {
        if (columnFormatter == null) {
            throw new SystemException(this.getClass(), String.format("invalid format for column '%s'", this.getColumnName()));
        }
        this.fmtColumnFormatter = columnFormatter;
    }

    @Override
    public void setFormat(String strFormatString) throws SystemException {
        this.fmtColumnFormatter = new SimpleDateFormat(strFormatString, Config.LOCALE);
        this.fmtColumnFormatter.setLenient(true);
        strFormatString = strFormatString.replaceAll("yyyy", "yy");
        strFormatString = strFormatString.replaceAll("YYYY", "yy");
        this.fmtColumnParser = new SimpleDateFormat(strFormatString, Config.LOCALE);
        this.fmtColumnParser.setLenient(true);
        this.datetime = strFormatString.contains(":") || DbTableDefaultPresetColumns.isDefaultPresetColumn(this.getColumnName());
    }

    public boolean isDateTime() {
        return this.datetime;
    }

    public void setDateTime(boolean datetime) {
        this.datetime = datetime;
    }

    @Override
    public ColumnTypes getType() {
        return ColumnTypes.CT_DATE_COLUMN;
    }

    @Override
    public char getColumnQuote() {
        return '\'';
    }

    @Override
    public void setStringValue(String strValue) {
        if (strValue == null) {
            strValue = "";
        }
        this.ObjectValue = strValue;
    }

    @Override
    public String getStringValue() {
        if (this.ObjectValue == null) {
            return "";
        }
        if (this.ObjectValue instanceof String) {
            return (String)this.ObjectValue;
        }
        return this.format(this.ObjectValue);
    }

    @Override
    public void setObjectValue(Object objValue) {
        this.ObjectValue = objValue;
    }

    @Override
    public Object getObjectValue() {
        return this.ObjectValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toDbDate(Date date) {
        if (this.getConnectionInfo() != null && (this.getConnectionInfo().isMySQL() || this.getConnectionInfo().isMariaDB())) {
            DateFormat dateFormat = fmtMySQLDateTimeFormatter;
            synchronized (dateFormat) {
                try {
                    return fmtMySQLDateTimeFormatter.format(date);
                }
                catch (Exception e) {
                    return fmtMySQLDateFormatter.format(date);
                }
            }
        }
        return this.format(date);
    }

    @Override
    protected ValidationError validateDataString(String strValue) {
        ValidationError superError = super.validateDataString(strValue);
        if (superError != null) {
            if (superError.getType() == ValidationErrorType.NULL_NOT_ALLOWED) {
                return superError;
            }
            String strNeededFormat = "Datumsformat";
            if (this.isDateTime()) {
                strNeededFormat = "Datums- und Zeitformat";
            }
            return this.validationError4Message(String.format("Datenfeld '%s'. Bitte geben sie ein g\u00fcltiges %s ein. (Ihre Eingabe: [%s], Fehlermeldung: '%s')", this.getColumnNameExternal(), strNeededFormat, strValue, superError.getErrorMessage()), ValidationErrorType.INVALID_DATA_FORMAT, null);
        }
        return null;
    }

    @Override
    protected ValidationError validateDataObject(Object data) {
        ValidationError error = super.validateDataObject(data);
        if (error != null) {
            return error;
        }
        if (data != null && !(data instanceof Date)) {
            return this.validationError4Message(String.format("Datenfeld '%s'. Ung\u00fcltige Objektart '%s' f\u00fcr Datum (bzw. Zeit)  \u00fcbergeben.", this.getColumnNameExternal(), data.getClass().getCanonicalName()), ValidationErrorType.INVALID_DATA_TYPE, null);
        }
        return null;
    }

    @Override
    public Comparator<Object> getColumnValueComparator() {
        return new Comparator<Object>(){
            private final Comparator<Object> dComp = new DateComparator();

            @Override
            public int compare(Object o1, Object o2) {
                return this.dComp.compare(o1, o2);
            }
        };
    }

    @Override
    public AttributeDescriptor buildDescriptor(AttributeTypeBuilder attBuilder) {
        this.adjustTypeBuilder(attBuilder);
        attBuilder.setBinding(Date.class);
        return attBuilder.buildDescriptor(this.getColumnName(), attBuilder.buildType());
    }

    static {
        DEFAULT_PARSER.setLenient(true);
        fmtMySQLDateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        fmtMySQLDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    }
}

