/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.riwadatatable.columns;

import de.riwagis.riwadatatable.columns.TableColumn;
import de.riwagis.riwadatatable.columns.defaultvalues.DefaultValue;
import de.riwagis.riwadatatable.filter.DataTableQuery;
import de.riwagis.riwadatatable.filter.QueryLinkType;
import de.riwagis.riwadatatable.filter.dbparser.FilterTermFactory;
import de.riwagis.riwadatatable.filter.dbparser.FilterTermHandler;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionInfo;
import de.riwagis.riwadatatable.jdbc.JDBCConnectionManager;
import de.riwagis.riwadatatable.validation.ValidationError;
import de.riwagis.riwadatatable.validation.ValidationErrorType;
import de.riwagis.util.exception.SystemException;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.feature.AttributeTypeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColumn
implements TableColumn {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractColumn.class);
    private final String strTableName;
    private final String strColumnName;
    private final int intColumnSize;
    private final JDBCConnectionInfo connInfo;
    private int intNullable;
    private int primaryKeyIndex = -1;
    protected DefaultValue defaultValue;
    private String strExtColumnName;
    private final List<FilterTermHandler> filterTermHandlers;
    private boolean unsigned;
    private boolean onlySelect = false;

    public AbstractColumn(String tableName, String columnName, int intColumnSize, int intNullable, DefaultValue defaultValue, JDBCConnectionInfo connInfo) {
        this.strColumnName = columnName;
        this.strTableName = tableName;
        this.intColumnSize = intColumnSize;
        this.intNullable = intNullable;
        this.connInfo = connInfo;
        try {
            this.setDefaultValue(defaultValue);
        }
        catch (Throwable t) {
            LOG.debug(t.getMessage(), t);
        }
        this.filterTermHandlers = FilterTermFactory.createFilterTermHandlers4Column(this);
        this.unsigned = false;
    }

    protected DefaultValue cloneDefaultValue(JDBCConnectionManager connMngr) {
        DefaultValue defaultValueInternal = this.getDefaultValueInternal();
        DefaultValue defaultValueCloned = null;
        if (defaultValueInternal != null) {
            defaultValueCloned = defaultValueInternal.cloneDefaultValue(connMngr);
        }
        return defaultValueCloned;
    }

    protected TableColumn overtakeNotFinalColumnAttributes(TableColumn clonedColumn) {
        clonedColumn.setPrimaryKeyIndex(this.getPrimaryKeyIndex());
        clonedColumn.setColumnNameExternal(this.getColumnNameExternal());
        clonedColumn.setUnsigned(this.isUnsigned());
        clonedColumn.setOnlySelect(this.isOnlySelect());
        return clonedColumn;
    }

    @Override
    @Deprecated
    public final int getColumnType() {
        return this.getType().getId();
    }

    @Override
    public String getSelectString() {
        return this.maskReservedWordsInColumnName(this.strColumnName);
    }

    @Override
    public final String getColumnName() {
        return this.strColumnName;
    }

    @Override
    public final String getTableName() {
        return this.strTableName;
    }

    @Override
    public final int getColumnSize() {
        return this.intColumnSize;
    }

    @Override
    public final JDBCConnectionInfo getConnectionInfo() {
        return this.connInfo;
    }

    @Override
    public final String getColumnNameExternal() {
        return this.strExtColumnName;
    }

    protected final int getNullable() {
        return this.intNullable;
    }

    @Override
    public final void setColumnNameExternal(String extColumnName) {
        this.strExtColumnName = extColumnName;
    }

    @Override
    public final boolean isNullable() {
        return 0 != this.intNullable;
    }

    @Override
    public final void setNullable(int nullable) {
        this.intNullable = nullable;
    }

    @Override
    public final int getPrimaryKeyIndex() {
        return this.primaryKeyIndex;
    }

    @Override
    public void setPrimaryKeyIndex(int primaryKeyIndex) {
        this.primaryKeyIndex = primaryKeyIndex;
    }

    protected void adjustTypeBuilder(AttributeTypeBuilder attBuilder) {
        attBuilder.setName(this.getColumnName());
        attBuilder.setNillable(this.isNullable());
        attBuilder.setDefaultValue(this.getDefaultValue());
        if (this.primaryKeyIndex > 0) {
            attBuilder.setIdentifiable(true);
        }
    }

    protected ValidationError validateDataString(String data) {
        try {
            Object objData = this.parseObject(data);
            return this.validateDataObject(objData);
        }
        catch (Throwable t) {
            return this.validationError4Message(t.getMessage(), ValidationErrorType.INVALID_DATA_FORMAT, t);
        }
    }

    protected ValidationError validateDataObject(Object data) {
        if (data == null && !this.isNullable()) {
            return this.validationError4Message(String.format("Datenfeld '%s' darf nicht leer sein.", this.getColumnNameExternal()), ValidationErrorType.NULL_NOT_ALLOWED, null);
        }
        return null;
    }

    @Override
    public ValidationError validateData(Object data) {
        if (data != null && data instanceof String) {
            return this.validateDataString((String)data);
        }
        return this.validateDataObject(data);
    }

    @Override
    public Object getDefaultValue() {
        try {
            if (this.defaultValue == null) {
                return null;
            }
            return this.defaultValue.getDefaultValue(this);
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Error getting default for column %s of table %s. Should never reach here.", this.strColumnName, this.strTableName), t);
        }
    }

    @Override
    public final DefaultValue getDefaultValueInternal() {
        return this.defaultValue;
    }

    @Override
    public final void setDefaultValue(DefaultValue defaultValue) {
        this.defaultValue = defaultValue;
    }

    protected final ValidationError validationError4Message(String errorMessage, ValidationErrorType type, Throwable linkedException) {
        return new ValidationError(this, errorMessage, type, linkedException);
    }

    @Override
    public void addFilter2Query(DataTableQuery query, QueryLinkType linkType, String term, boolean ignoreEmptyTerm) throws SystemException {
        String termNullSafe = ObjectUtils.toString((Object)term);
        if (ignoreEmptyTerm && StringUtils.isBlank((String)termNullSafe)) {
            return;
        }
        QueryLinkType.appendLink(query, linkType);
        boolean filterHandled = false;
        for (FilterTermHandler fth : this.filterTermHandlers) {
            if (query.isAvoidPrepStatementHint()) {
                if (!fth.handleFilterTermWithoutPreparedStatement(termNullSafe, query)) continue;
                filterHandled = true;
                break;
            }
            if (!fth.handleFilterTerm(termNullSafe, query)) continue;
            filterHandled = true;
            break;
        }
        if (!filterHandled) {
            throw new SystemException(String.format("Filter '%s' to table '%s', column '%s' could not be handled.", termNullSafe, this.strTableName, this.strColumnName));
        }
    }

    @Override
    public boolean isUnsigned() {
        return this.unsigned;
    }

    @Override
    public void setUnsigned(boolean unsigned) {
        this.unsigned = unsigned;
    }

    private String maskReservedWordsInColumnName(String colName) {
        if (StringUtils.isBlank((String)colName)) {
            return colName;
        }
        if (this.connInfo != null && this.connInfo.isOracle()) {
            if (colName.equalsIgnoreCase("file")) {
                return "\"FILE\"";
            }
        } else if (this.connInfo != null && this.connInfo.isMSSQLServer() && colName.equalsIgnoreCase("textsize")) {
            return "[textsize]";
        }
        return colName;
    }

    public String toString() {
        return String.format("%s '%s' (%s_%s)", this.getClass().getName(), this.getColumnName(), this.getColumnTypeString(), this.getColumnSize());
    }

    @Override
    public boolean isOnlySelect() {
        return this.onlySelect;
    }

    @Override
    public void setOnlySelect(boolean onlySelect) {
        this.onlySelect = onlySelect;
    }
}

