/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc.errorhandling;

import de.riwagis.util.jdbc.DatabaseType;
import de.riwagis.util.jdbc.errorhandling.ErrorCodeClass;
import de.riwagis.util.jdbc.errorhandling.ErrorCodeClassUtils;
import de.riwagis.util.jdbc.errorhandling.UserFormattedSQLException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLExceptionMapper {
    private static final Logger LOG = LoggerFactory.getLogger(SQLExceptionMapper.class);
    private static final String BUNDLE_NAME_DEFAULT = "de.riwagis.util.jdbc.errorhandling.ErrorCodeClass";
    private static final String BUNDLE_NAME_USER = "de.riwagis.util.jdbc.errorhandling.ErrorCodeClassUser";

    public static final SQLException mapException(Connection conn, SQLException sqlex) {
        return SQLExceptionMapper.mapException(Locale.getDefault(), conn, sqlex);
    }

    public static final SQLException mapException(Locale loc, Connection conn, SQLException sqlex) {
        ErrorCodeClass ecc;
        if (sqlex != null && (ecc = ErrorCodeClassUtils.detectFromException(DatabaseType.findByProductNameQuietly(conn), sqlex)) != ErrorCodeClass.UNKNOWN) {
            try {
                String errTextLocUser;
                ResourceBundle userBundle = ResourceBundle.getBundle(BUNDLE_NAME_USER, loc);
                if (userBundle != null && StringUtils.isNotBlank((String)(errTextLocUser = userBundle.getString(String.format("codetext." + ecc.name(), new Object[0]))))) {
                    return new UserFormattedSQLException(errTextLocUser, sqlex.getSQLState(), sqlex.getErrorCode(), sqlex, ecc);
                }
            }
            catch (MissingResourceException fx) {
                LOG.debug(String.format("missing user bundle '%s', using default bundle", BUNDLE_NAME_USER), (Throwable)fx);
            }
            ResourceBundle defaultBundle = ResourceBundle.getBundle(BUNDLE_NAME_DEFAULT, loc);
            String errTextLoc = defaultBundle.getString(String.format("codetext." + ecc.name(), new Object[0]));
            return new UserFormattedSQLException(errTextLoc, sqlex.getSQLState(), sqlex.getErrorCode(), sqlex, ecc);
        }
        return sqlex;
    }

    private SQLExceptionMapper() {
    }
}

