/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc.errorhandling;

import de.riwagis.util.jdbc.DatabaseType;
import de.riwagis.util.jdbc.errorhandling.ErrorCodeClass;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ErrorCodeClassUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorCodeClassUtils.class);
    private static final Map<DatabaseType, Map<Integer, ErrorCodeClass>> vendorCodes = ErrorCodeClassUtils.readVendorCodes();
    public static final String RESOURCE_BASEFILENAME = "vendorCodeMapping";
    public static final String RESOURCE_PATH = "";

    public static final Map<DatabaseType, Map<Integer, ErrorCodeClass>> readVendorCodes() {
        LinkedHashMap<DatabaseType, Map<Integer, ErrorCodeClass>> errorCodesByProduct = new LinkedHashMap<DatabaseType, Map<Integer, ErrorCodeClass>>();
        for (DatabaseType currProduct : DatabaseType.values()) {
            String resourceName = currProduct != DatabaseType.DT_MSSQLSERVER ? String.format("%s%s.%s.properties", RESOURCE_PATH, RESOURCE_BASEFILENAME, currProduct.getIdentification()) : String.format("%s%s.%s.properties", RESOURCE_PATH, RESOURCE_BASEFILENAME, "MSSQLSERVER");
            LinkedHashMap<Integer, ErrorCodeClass> errs = new LinkedHashMap<Integer, ErrorCodeClass>();
            try {
                Properties p = new Properties();
                try (InputStream resourceStream = ErrorCodeClassUtils.class.getResourceAsStream(resourceName);){
                    if (resourceStream != null) {
                        p.load(resourceStream);
                    }
                }
                for (String currCode : p.stringPropertyNames()) {
                    try {
                        errs.put(Integer.valueOf(currCode), ErrorCodeClass.valueOf(p.getProperty(currCode)));
                    }
                    catch (Exception ex) {
                        LOG.warn(String.format("failed to read code '%s'='%s': %s", currCode, p.getProperty(currCode), ex.getMessage()), (Throwable)ex);
                    }
                }
                errorCodesByProduct.put(currProduct, errs);
            }
            catch (IOException ioex) {
                LOG.error(String.format("error reading codes for '%s': %s", new Object[]{currProduct, ioex.getMessage()}), (Throwable)ioex);
            }
        }
        return errorCodesByProduct;
    }

    public static ErrorCodeClass detectFromException(DatabaseType dbProduct, SQLException sqlEx) {
        if (sqlEx != null) {
            return ErrorCodeClassUtils.detect(dbProduct, sqlEx.getErrorCode());
        }
        return ErrorCodeClass.UNKNOWN;
    }

    public static ErrorCodeClass detectFromException(Connection conn, SQLException sqlEx) throws SQLException {
        return ErrorCodeClassUtils.detectFromException(DatabaseType.findByProductName(conn), sqlEx);
    }

    static final ErrorCodeClass detect(DatabaseType dbProduct, Integer i) {
        ErrorCodeClass errCodeClass;
        Map<Integer, ErrorCodeClass> codesForProduct;
        if (dbProduct != null && i != null && (codesForProduct = vendorCodes.get((Object)dbProduct)) != null && (errCodeClass = codesForProduct.get(i)) != null) {
            return errCodeClass;
        }
        return ErrorCodeClass.UNKNOWN;
    }

    private ErrorCodeClassUtils() {
    }
}

