/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DatabaseType {
    DT_UNKNOWN("UNKNOWN", "", "", ""),
    DT_POSTGRES("POSTGRESQL", "POSTGRESQL", "org\\.postgresql\\.Driver", "jdbc:postgresql:"),
    DT_MYSQL("MYSQL", "MYSQL", "com\\.mysql\\.jdbc\\.Driver|org\\.gjt\\.mm\\.mysql\\.Driver", "jdbc:mysql:"),
    DT_MARIADB("MARIADB", "MARIADB", "org\\.mariadb\\.jdbc\\.Driver", "jdbc:mariadb:"),
    DT_ORACLE("ORACLE", "ORACLE", "oracle\\.jdbc(\\.driver)?\\.OracleDriver", "jdbc:oracle(:[^:]+):"),
    DT_HSQLDB("HSQL Database Engine", ".*HSQL.*", "org\\.hsqldb\\.jdbcDriver", "jdbc:hsqldb(:[^:]+):"),
    DT_MSSQLSERVER("Microsoft SQL Server", "Microsoft ?SQL ?Server|sqlserver", "net\\.sourceforge\\.jtds\\.jdbc\\.Driver", "jdbc:jtds:sqlserver:");

    private static final Logger LOG;
    private final String identification;
    private final Pattern productNamePattern;
    private final Pattern driverClassPattern;
    private final Pattern jdbcURIPattern;

    public static final boolean isDatabaseType(Connection databaseConnection, DatabaseType dbType) throws SQLException {
        return ObjectUtils.equals((Object)((Object)dbType), (Object)((Object)DatabaseType.findByProductName(databaseConnection)));
    }

    public static final DatabaseType findByProductName(Connection databaseConnection) throws SQLException {
        return DatabaseType.findByProductName(databaseConnection.getMetaData().getDatabaseProductName());
    }

    public static final DatabaseType findByProductNameQuietly(Connection databaseConnection) {
        try {
            return DatabaseType.findByProductName(databaseConnection.getMetaData().getDatabaseProductName());
        }
        catch (Throwable t) {
            LOG.warn(String.format("unable to determine productname from connection '%s': %s", databaseConnection, t.getMessage()), t);
            return DT_UNKNOWN;
        }
    }

    public static final DatabaseType findByProductName(String databaseProductName) {
        if (StringUtils.isNotBlank((String)databaseProductName)) {
            for (DatabaseType currDBProduct : DatabaseType.values()) {
                Pattern productNamePattern = currDBProduct.getProductNamePattern();
                if (productNamePattern == null || !productNamePattern.matcher(databaseProductName).matches()) continue;
                return currDBProduct;
            }
        }
        return DT_UNKNOWN;
    }

    public static final DatabaseType findByDriverClass(String driverClassName) {
        for (DatabaseType currDatabaseType : DatabaseType.values()) {
            Pattern productNamePattern = currDatabaseType.getProductNamePattern();
            if (productNamePattern == null || !productNamePattern.matcher(driverClassName).matches()) continue;
            return currDatabaseType;
        }
        return DT_UNKNOWN;
    }

    public static final DatabaseType findByDriverClass(Connection databaseConnection) throws SQLException {
        String driverName = databaseConnection.getMetaData().getDriverName();
        return DatabaseType.findByDriverClass(driverName);
    }

    public static final DatabaseType findByJDBCURL(String databaseURL) {
        if (StringUtils.isNotBlank((String)databaseURL)) {
            for (DatabaseType currDatabaseType : DatabaseType.values()) {
                Pattern uriPattern = currDatabaseType.getJdbcURIPattern();
                if (uriPattern == null || !uriPattern.matcher(databaseURL).lookingAt()) continue;
                return currDatabaseType;
            }
        }
        return DT_UNKNOWN;
    }

    private DatabaseType(String identification, String databaseNamePattern, String driverClassPattern, String jdbcURIPattern) {
        this.productNamePattern = DatabaseType.compilePattern(StringUtils.defaultIfEmpty((String)databaseNamePattern, (String)identification), 2);
        this.identification = identification;
        this.driverClassPattern = DatabaseType.compilePattern(driverClassPattern, 0);
        this.jdbcURIPattern = DatabaseType.compilePattern(jdbcURIPattern, 0);
    }

    public static Pattern compilePattern(String regexPattern, int flags) {
        return StringUtils.isNotBlank((String)regexPattern) ? Pattern.compile(regexPattern, flags) : null;
    }

    public String getIdentification() {
        return this.identification;
    }

    public final Pattern getProductNamePattern() {
        return this.productNamePattern;
    }

    public final Pattern getDriverClassPattern() {
        return this.driverClassPattern;
    }

    public Pattern getJdbcURIPattern() {
        return this.jdbcURIPattern;
    }

    static {
        LOG = LoggerFactory.getLogger(DatabaseType.class);
    }
}

