/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc;

import de.riwagis.util.jdbc.DatabaseType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionUtils.class);

    public static String getConnectionURLQuietly(Connection conn) {
        try {
            return conn.getMetaData().getURL();
        }
        catch (Throwable t) {
            LOG.warn(String.format("unable to retrieve connection url: %s", t.getMessage()));
            return null;
        }
    }

    public static List<String> getTableList(Connection conn, String schemaName, String excludePattern) throws SQLException {
        String[] tableTypes = new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "SYNONYM"};
        return ConnectionUtils.getTableList(conn, tableTypes, schemaName, excludePattern);
    }

    public static List<String> getTableList(Connection conn, String[] desiredTablesTypes, String schemaName, String excludePattern) throws SQLException {
        int TABLE_NAME_COL = 3;
        ArrayList<String> list = new ArrayList<String>();
        DatabaseMetaData meta = conn.getMetaData();
        HashSet<String> availableTableTypes = new HashSet<String>();
        try (ResultSet dbTableTypes = meta.getTableTypes();){
            while (dbTableTypes.next()) {
                availableTableTypes.add(dbTableTypes.getString("TABLE_TYPE"));
            }
        }
        HashSet<String> queryTypes = new HashSet<String>();
        for (String desiredTableType : desiredTablesTypes) {
            if (!availableTableTypes.contains(desiredTableType)) continue;
            queryTypes.add(desiredTableType);
        }
        String querySchema = ConnectionUtils.escapeNamePattern(meta, schemaName);
        String queryCatalog = null;
        if (DatabaseType.isDatabaseType(conn, DatabaseType.DT_MYSQL) || DatabaseType.isDatabaseType(conn, DatabaseType.DT_MARIADB)) {
            queryCatalog = schemaName;
            querySchema = null;
        }
        ResultSet tables = meta.getTables(queryCatalog, querySchema, "%", (String[])queryTypes.toArray(String[]::new));
        Pattern excludePatternObj = null;
        if (StringUtils.isNotBlank((String)excludePattern)) {
            excludePatternObj = Pattern.compile(excludePattern);
        }
        while (tables.next()) {
            String tableName = tables.getString(3);
            if (StringUtils.isNotBlank((String)excludePattern)) {
                if (excludePatternObj.matcher(tableName).matches()) continue;
                list.add(tableName);
                continue;
            }
            list.add(tableName);
        }
        return list;
    }

    public static String escapeNamePattern(DatabaseMetaData metaData, String name) throws SQLException {
        return new NamePatternEscaping(metaData.getSearchStringEscape()).escape(name);
    }

    public static boolean tableExists(Connection conn, String tableName) throws SQLException {
        return ConnectionUtils.tableExists(conn, tableName, null);
    }

    public static boolean tableExists(Connection conn, String tableName, String[] desiredTablesTypes) throws SQLException {
        if (DatabaseType.isDatabaseType(conn, DatabaseType.DT_ORACLE)) {
            if (conn.getMetaData().getDriverMajorVersion() <= 11) {
                return ConnectionUtils.tableExists(conn, null, null, tableName.toUpperCase(), desiredTablesTypes);
            }
            return ConnectionUtils.tableExists(conn, conn.getCatalog(), conn.getSchema(), tableName.toUpperCase(), desiredTablesTypes);
        }
        return ConnectionUtils.tableExists(conn, conn.getCatalog(), conn.getSchema(), tableName, desiredTablesTypes);
    }

    public static boolean tableExists(Connection conn, String catalogName, String schemaName, String tableName, String[] desiredTablesTypes) throws SQLException {
        DatabaseMetaData dbm = conn.getMetaData();
        try (ResultSet rs = dbm.getTables(catalogName, schemaName, tableName, desiredTablesTypes);){
            boolean bl = rs.next();
            return bl;
        }
    }

    private ConnectionUtils() {
    }

    private static class NamePatternEscaping {
        private final String escape;
        private final Pattern replacementPattern;
        private final String replacement;

        public NamePatternEscaping(String escape) {
            this.escape = escape == null ? "" : escape;
            String quotedEscape = Pattern.quote(this.escape);
            this.replacementPattern = Pattern.compile("(" + quotedEscape + "|[_%])");
            this.replacement = Matcher.quoteReplacement(this.escape) + "$1";
        }

        public String escape(String name) {
            if (this.needsEscaping(name)) {
                return this.replacementPattern.matcher(name).replaceAll(this.replacement);
            }
            return name;
        }

        private boolean needsEscaping(String name) {
            if (name == null) {
                return false;
            }
            if (this.escape.isEmpty()) {
                return false;
            }
            return name.indexOf(95) != -1 || name.indexOf(37) != -1 || name.contains(this.escape);
        }
    }
}

