/*
 * Decompiled with CFR 0.152.
 */
package au.com.objectix.jgridshift.sample.gui;

import au.com.objectix.jgridshift.SubGrid;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SubGridTreeModel
implements TreeModel {
    private static final int MIN_LAT = 0;
    private static final int MAX_LAT = 1;
    private static final int MIN_LON = 2;
    private static final int MAX_LON = 3;
    private SubGrid[] subGridTree;
    private RootNode root;

    public SubGridTreeModel() {
        this.root = new RootNode(0);
    }

    public SubGridTreeModel(SubGrid[] subGridTree) {
        this.subGridTree = subGridTree;
        this.root = new RootNode(subGridTree.length);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            return this.subGridTree[index];
        }
        SubGrid parentSubGrid = (SubGrid)parent;
        if (index < 4) {
            switch (index) {
                case 0: {
                    return new DimensionNode(0, parentSubGrid.getMinLat());
                }
                case 1: {
                    return new DimensionNode(1, parentSubGrid.getMaxLat());
                }
                case 2: {
                    return new DimensionNode(2, parentSubGrid.getMinLon());
                }
                case 3: {
                    return new DimensionNode(3, parentSubGrid.getMaxLon());
                }
            }
            throw new IllegalArgumentException("");
        }
        return parentSubGrid.getSubGrid(index - 4);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.root) {
            return this.root.getNodeCount();
        }
        return ((SubGrid)parent).getSubGridCount() + 4;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean leaf = node instanceof DimensionNode;
        if (!leaf && node instanceof RootNode) {
            RootNode root = (RootNode)node;
            leaf = root.getNodeCount() == 0;
        }
        return leaf;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.root) {
            for (int i = 0; i < this.subGridTree.length; ++i) {
                if (this.subGridTree[i] != child) continue;
                return i;
            }
            throw new IllegalArgumentException(child + " not a child of this parent " + parent);
        }
        if (child instanceof DimensionNode) {
            return ((DimensionNode)child).getType();
        }
        SubGrid parentSubGrid = (SubGrid)parent;
        for (int i = 0; i < parentSubGrid.getSubGridCount(); ++i) {
            if (parentSubGrid.getSubGrid(i) != child) continue;
            return i;
        }
        throw new IllegalArgumentException(child + " not a child of this parent " + parent);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    public static class RootNode {
        private int nodeCount;

        public RootNode(int nodeCount) {
            this.nodeCount = nodeCount;
        }

        public int getNodeCount() {
            return this.nodeCount;
        }

        public String toString() {
            if (this.nodeCount == 0) {
                return "Not Loaded";
            }
            return "";
        }
    }

    public static class DimensionNode {
        int type;
        double value;

        public DimensionNode(int type, double value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            switch (this.type) {
                case 0: {
                    buf.append("Min Lat: ");
                    break;
                }
                case 1: {
                    buf.append("Max Lat: ");
                    break;
                }
                case 2: {
                    buf.append("Min Lon: ");
                    break;
                }
                case 3: {
                    buf.append("Max Lon: ");
                }
            }
            buf.append(this.value);
            return buf.toString();
        }

        public int getType() {
            return this.type;
        }
    }
}

