/*
 * Decompiled with CFR 0.152.
 */
package au.com.objectix.jgridshift.sample.gui;

import au.com.objectix.jgridshift.GridShift;
import au.com.objectix.jgridshift.sample.gui.Gui;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class GuiPanel
extends JPanel {
    private static final String NOT_GSF = "Not a valid GridShift File";
    private static final String DEGREE = "Degrees (Positive East Lon)";
    private static final String SECOND = "Seconds (Positive West Lon)";
    private static final String DMS = "DMS (Positive East Lon)";
    private static final Integer ZERO = new Integer(0);
    private Object[] display = new Object[]{"Degrees (Positive East Lon)", "Seconds (Positive West Lon)", "DMS (Positive East Lon)"};
    private EntryFocus entryFocus = new EntryFocus();
    private JPanel filePanel = new JPanel();
    private JLabel gridShiftFileLabel = new JLabel("Grid Shift File: ");
    private JTextField gridShiftFileName = new JTextField(20);
    private JButton fileButton = new JButton("...");
    private JLabel gridShiftErrorLabel = new JLabel(" ");
    private JLabel filler1 = new JLabel(" ");
    private JLabel filler2 = new JLabel("         ");
    private JFileChooser fileChooser = new JFileChooser();
    private Gui gui;
    private GridShift gridShift = new GridShift();
    private JPanel fromPanel = new JPanel(new BorderLayout());
    private JLabel fromLabel = new JLabel("From Coordinate  ");
    private JComboBox fromCombo = new JComboBox<Object>(this.display);
    private CardLayout fromCardLayout = new CardLayout();
    private JPanel fromCardPanel = new JPanel(this.fromCardLayout);
    private GridLayout fromDegreeLayout = new GridLayout(2, 2);
    private JPanel fromDegreePanel = new JPanel(this.fromDegreeLayout);
    private JLabel fromDegreeLonLabel = new JLabel("Lon: ");
    private JLabel fromDegreeLatLabel = new JLabel("Lat: ");
    private DecimalFormat degreeDecimalFormat = new DecimalFormat("##0.000000000");
    private JTextField fromDegreeLonText = new JTextField();
    private JTextField fromDegreeLatText = new JTextField();
    private GridLayout fromSecondLayout = new GridLayout(2, 2);
    private JPanel fromSecondPanel = new JPanel(this.fromSecondLayout);
    private JLabel fromSecondLonLabel = new JLabel("Lon: ");
    private JLabel fromSecondLatLabel = new JLabel("Lat: ");
    private DecimalFormat secondDecimalFormat = new DecimalFormat("######0.00000");
    private JTextField fromSecondLonText = new JTextField();
    private JTextField fromSecondLatText = new JTextField();
    private GridLayout fromDMSLayout = new GridLayout(2, 4);
    private JPanel fromDMSPanel = new JPanel(this.fromDMSLayout);
    private JLabel fromDMSLonLabel = new JLabel("Lon: ");
    private JLabel fromDMSLatLabel = new JLabel("Lat: ");
    private DecimalFormat degMinDecimalFormat = new DecimalFormat("##0");
    private JTextField fromDMSDegLonText = new JTextField();
    private JTextField fromDMSDegLatText = new JTextField();
    private JTextField fromDMSMinLonText = new JTextField();
    private JTextField fromDMSMinLatText = new JTextField();
    private JTextField fromDMSSecLonText = new JTextField();
    private JTextField fromDMSSecLatText = new JTextField();
    private JPanel toPanel = new JPanel(new BorderLayout());
    private JLabel toLabel = new JLabel("To Coordinate    ");
    private JComboBox toCombo = new JComboBox<Object>(this.display);
    private CardLayout toCardLayout = new CardLayout();
    private JPanel toCardPanel = new JPanel(this.toCardLayout);
    private GridLayout toDegreeLayout = new GridLayout(2, 2);
    private JPanel toDegreePanel = new JPanel(this.toDegreeLayout);
    private JLabel toDegreeLonLabel = new JLabel("Lon: ");
    private JLabel toDegreeLatLabel = new JLabel("Lat: ");
    private JFormattedTextField toDegreeLonText = new JFormattedTextField(this.degreeDecimalFormat);
    private JFormattedTextField toDegreeLatText = new JFormattedTextField(this.degreeDecimalFormat);
    private GridLayout toSecondLayout = new GridLayout(2, 2);
    private JPanel toSecondPanel = new JPanel(this.toSecondLayout);
    private JLabel toSecondLonLabel = new JLabel("Lon: ");
    private JLabel toSecondLatLabel = new JLabel("Lat: ");
    private JFormattedTextField toSecondLonText = new JFormattedTextField(this.secondDecimalFormat);
    private JFormattedTextField toSecondLatText = new JFormattedTextField(this.secondDecimalFormat);
    private GridLayout toDMSLayout = new GridLayout(2, 4);
    private JPanel toDMSPanel = new JPanel(this.toDMSLayout);
    private JLabel toDMSLonLabel = new JLabel("Lon: ");
    private JLabel toDMSLatLabel = new JLabel("Lat: ");
    private JFormattedTextField toDMSDegLonText = new JFormattedTextField(this.degMinDecimalFormat);
    private JFormattedTextField toDMSDegLatText = new JFormattedTextField(this.degMinDecimalFormat);
    private JFormattedTextField toDMSMinLonText = new JFormattedTextField(this.degMinDecimalFormat);
    private JFormattedTextField toDMSMinLatText = new JFormattedTextField(this.degMinDecimalFormat);
    private JFormattedTextField toDMSSecLonText = new JFormattedTextField(this.secondDecimalFormat);
    private JFormattedTextField toDMSSecLatText = new JFormattedTextField(this.secondDecimalFormat);
    private JLabel message = new JLabel(" ");
    private JButton forwardButton = new JButton("Not Loaded");
    private JButton reverseButton = new JButton("Not Loaded");

    public GuiPanel(String gridShiftFile, GridBagLayout gridbag, Gui gui) throws Exception {
        super(gridbag);
        this.gui = gui;
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        this.filePanel.add(this.gridShiftFileLabel);
        this.gridShiftFileName.setText(gridShiftFile);
        FileVerifier fileVerifier = new FileVerifier();
        this.gridShiftFileName.setInputVerifier(fileVerifier);
        this.filePanel.add(this.gridShiftFileName);
        this.filePanel.add(this.fileButton);
        this.gridShiftErrorLabel.setForeground(Color.RED);
        this.fileButton.addActionListener(new FileAction());
        this.fileChooser.setMultiSelectionEnabled(false);
        c.gridwidth = 0;
        gridbag.setConstraints(this.gridShiftErrorLabel, c);
        this.add(this.gridShiftErrorLabel);
        gridbag.setConstraints(this.filePanel, c);
        this.add(this.filePanel);
        gridbag.setConstraints(this.filler1, c);
        this.add(this.filler1);
        this.fromPanel.add((Component)this.fromLabel, "West");
        this.fromPanel.add((Component)this.fromCombo, "East");
        this.fromCombo.addActionListener(new FromAction());
        this.fromPanel.add((Component)this.fromCardPanel, "South");
        this.fromCardPanel.add((Component)this.fromDegreePanel, DEGREE);
        this.fromDegreePanel.add(this.fromDegreeLatLabel);
        this.fromDegreePanel.add(this.fromDegreeLatText);
        this.fromDegreeLatText.setInputVerifier(new FromLatDegreeVerifier());
        this.fromDegreeLatText.addFocusListener(this.entryFocus);
        this.fromDegreePanel.add(this.fromDegreeLonLabel);
        this.fromDegreePanel.add(this.fromDegreeLonText);
        this.fromDegreeLonText.setInputVerifier(new FromLonDegreeVerifier());
        this.fromDegreeLonText.addFocusListener(this.entryFocus);
        this.fromCardPanel.add((Component)this.fromSecondPanel, SECOND);
        this.fromSecondPanel.add(this.fromSecondLatLabel);
        this.fromSecondPanel.add(this.fromSecondLatText);
        this.fromSecondLatText.setInputVerifier(new FromLatSecondVerifier());
        this.fromSecondLatText.addFocusListener(this.entryFocus);
        this.fromSecondPanel.add(this.fromSecondLonLabel);
        this.fromSecondPanel.add(this.fromSecondLonText);
        this.fromSecondLonText.setInputVerifier(new FromLonSecondVerifier());
        this.fromSecondLonText.addFocusListener(this.entryFocus);
        this.fromCardPanel.add((Component)this.fromDMSPanel, DMS);
        this.fromDMSPanel.add(this.fromDMSLatLabel);
        this.fromDMSPanel.add(this.fromDMSDegLatText);
        this.fromDMSDegLatText.setInputVerifier(new FromLatDMSDegVerifier());
        this.fromDMSDegLatText.addFocusListener(this.entryFocus);
        this.fromDMSPanel.add(this.fromDMSMinLatText);
        this.fromDMSMinLatText.setInputVerifier(new FromLatDMSMinVerifier());
        this.fromDMSMinLatText.addFocusListener(this.entryFocus);
        this.fromDMSPanel.add(this.fromDMSSecLatText);
        this.fromDMSSecLatText.setInputVerifier(new FromLatDMSSecVerifier());
        this.fromDMSSecLatText.addFocusListener(this.entryFocus);
        this.fromDMSSecLatText.setColumns(6);
        this.fromDMSPanel.add(this.fromDMSLonLabel);
        this.fromDMSPanel.add(this.fromDMSDegLonText);
        this.fromDMSDegLonText.setInputVerifier(new FromLonDMSDegVerifier());
        this.fromDMSDegLonText.addFocusListener(this.entryFocus);
        this.fromDMSPanel.add(this.fromDMSMinLonText);
        this.fromDMSMinLonText.setInputVerifier(new FromLonDMSMinVerifier());
        this.fromDMSMinLonText.addFocusListener(this.entryFocus);
        this.fromDMSPanel.add(this.fromDMSSecLonText);
        this.fromDMSSecLonText.setInputVerifier(new FromLonDMSSecVerifier());
        this.fromDMSSecLonText.addFocusListener(this.entryFocus);
        c.gridwidth = 1;
        gridbag.setConstraints(this.fromPanel, c);
        this.add(this.fromPanel);
        gridbag.setConstraints(this.filler2, c);
        this.add(this.filler2);
        this.toPanel.add((Component)this.toLabel, "West");
        this.toPanel.add((Component)this.toCombo, "East");
        this.toCombo.addActionListener(new ToAction());
        this.toPanel.add((Component)this.toCardPanel, "South");
        this.toCardPanel.add((Component)this.toDegreePanel, DEGREE);
        this.toDegreePanel.add(this.toDegreeLatLabel);
        this.toDegreePanel.add(this.toDegreeLatText);
        this.toDegreeLatText.setEditable(false);
        this.toDegreeLatText.setFocusLostBehavior(3);
        this.toDegreePanel.add(this.toDegreeLonLabel);
        this.toDegreePanel.add(this.toDegreeLonText);
        this.toDegreeLonText.setEditable(false);
        this.toDegreeLonText.setFocusLostBehavior(3);
        this.toCardPanel.add((Component)this.toSecondPanel, SECOND);
        this.toSecondPanel.add(this.toSecondLatLabel);
        this.toSecondPanel.add(this.toSecondLatText);
        this.toSecondLatText.setEditable(false);
        this.toSecondLatText.setFocusLostBehavior(3);
        this.toSecondPanel.add(this.toSecondLonLabel);
        this.toSecondPanel.add(this.toSecondLonText);
        this.toSecondLonText.setEditable(false);
        this.toSecondLonText.setFocusLostBehavior(3);
        this.toCardPanel.add((Component)this.toDMSPanel, DMS);
        this.toDMSPanel.add(this.toDMSLatLabel);
        this.toDMSPanel.add(this.toDMSDegLatText);
        this.toDMSDegLatText.setEditable(false);
        this.toDMSDegLatText.setFocusLostBehavior(3);
        this.toDMSPanel.add(this.toDMSMinLatText);
        this.toDMSMinLatText.setEditable(false);
        this.toDMSMinLatText.setFocusLostBehavior(3);
        this.toDMSPanel.add(this.toDMSSecLatText);
        this.toDMSSecLatText.setEditable(false);
        this.toDMSSecLatText.setFocusLostBehavior(3);
        this.toDMSSecLatText.setColumns(6);
        this.toDMSPanel.add(this.toDMSLonLabel);
        this.toDMSPanel.add(this.toDMSDegLonText);
        this.toDMSDegLonText.setEditable(false);
        this.toDMSDegLonText.setFocusLostBehavior(3);
        this.toDMSPanel.add(this.toDMSMinLonText);
        this.toDMSMinLonText.setEditable(false);
        this.toDMSMinLonText.setFocusLostBehavior(3);
        this.toDMSPanel.add(this.toDMSSecLonText);
        this.toDMSSecLonText.setEditable(false);
        this.toDMSSecLonText.setFocusLostBehavior(3);
        c.gridwidth = 0;
        gridbag.setConstraints(this.toPanel, c);
        this.add(this.toPanel);
        gridbag.setConstraints(this.message, c);
        this.add(this.message);
        this.forwardButton.setEnabled(false);
        this.forwardButton.addActionListener(new ForwardAction());
        gridbag.setConstraints(this.forwardButton, c);
        this.add(this.forwardButton);
        this.reverseButton.setEnabled(false);
        this.reverseButton.addActionListener(new ReverseAction());
        gridbag.setConstraints(this.reverseButton, c);
        this.add(this.reverseButton);
        if (gridShiftFile != null) {
            fileVerifier.verify(this.gridShiftFileName);
        }
    }

    public void clearToValues() {
        this.toDegreeLonText.setText("");
        this.toSecondLonText.setText("");
        this.toDMSDegLonText.setText("");
        this.toDMSMinLonText.setText("");
        this.toDMSSecLonText.setText("");
        this.toDegreeLatText.setText("");
        this.toSecondLatText.setText("");
        this.toDMSDegLatText.setText("");
        this.toDMSMinLatText.setText("");
        this.toDMSSecLatText.setText("");
        this.message.setText(" ");
    }

    public void setToValues() {
        this.toDegreeLonText.setValue(new Double(this.gridShift.getShiftedLonPositiveEastDegrees()));
        this.toSecondLonText.setValue(new Double(this.gridShift.getShiftedLonPositiveWestSeconds()));
        int deg = (int)(this.gridShift.getShiftedLonPositiveWestSeconds() / -3600.0);
        int min = (int)(Math.abs(this.gridShift.getShiftedLonPositiveWestSeconds()) / 60.0);
        double sec = Math.abs(this.gridShift.getShiftedLonPositiveWestSeconds()) - (double)min * 60.0;
        this.toDMSDegLonText.setValue(new Integer(deg));
        this.toDMSMinLonText.setValue(new Integer(min %= 60));
        this.toDMSSecLonText.setValue(new Double(sec));
        this.toDegreeLatText.setValue(new Double(this.gridShift.getShiftedLatDegrees()));
        this.toSecondLatText.setValue(new Double(this.gridShift.getShiftedLatSeconds()));
        deg = (int)(this.gridShift.getShiftedLatSeconds() / 3600.0);
        min = (int)(Math.abs(this.gridShift.getShiftedLatSeconds()) / 60.0);
        sec = Math.abs(this.gridShift.getShiftedLatSeconds()) - (double)min * 60.0;
        this.toDMSDegLatText.setValue(new Integer(deg));
        this.toDMSMinLatText.setValue(new Integer(min %= 60));
        this.toDMSSecLatText.setValue(new Double(sec));
    }

    public void setFromLonValues() {
        this.fromDegreeLonText.setText(this.degreeDecimalFormat.format(this.gridShift.getLonPositiveEastDegrees()));
        this.fromSecondLonText.setText(this.secondDecimalFormat.format(this.gridShift.getLonPositiveWestSeconds()));
        int deg = (int)(this.gridShift.getLonPositiveWestSeconds() / -3600.0);
        int min = (int)(Math.abs(this.gridShift.getLonPositiveWestSeconds()) / 60.0);
        double sec = Math.abs(this.gridShift.getLonPositiveWestSeconds()) - (double)min * 60.0;
        this.fromDMSDegLonText.setText(this.degMinDecimalFormat.format(deg));
        this.fromDMSMinLonText.setText(this.degMinDecimalFormat.format(min %= 60));
        this.fromDMSSecLonText.setText(this.secondDecimalFormat.format(sec));
    }

    public void setFromLatValues() {
        this.fromDegreeLatText.setText(this.degreeDecimalFormat.format(this.gridShift.getLatDegrees()));
        this.fromSecondLatText.setText(this.secondDecimalFormat.format(this.gridShift.getLatSeconds()));
        int deg = (int)(this.gridShift.getLatSeconds() / 3600.0);
        int min = (int)(Math.abs(this.gridShift.getLatSeconds()) / 60.0);
        double sec = Math.abs(this.gridShift.getLatSeconds()) - (double)min * 60.0;
        this.fromDMSDegLatText.setText(this.degMinDecimalFormat.format(deg));
        this.fromDMSMinLatText.setText(this.degMinDecimalFormat.format(min %= 60));
        this.fromDMSSecLatText.setText(this.secondDecimalFormat.format(sec));
    }

    class EntryFocus
    implements FocusListener {
        EntryFocus() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!e.isTemporary()) {
                JTextComponent t = (JTextComponent)e.getComponent();
                t.selectAll();
                GuiPanel.this.clearToValues();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    class FileVerifier
    extends InputVerifier {
        FileVerifier() {
        }

        @Override
        public boolean verify(JComponent comp) {
            String filePath = ((JTextField)comp).getText();
            if (filePath.equals("")) {
                GuiPanel.this.gui.unloadGridShiftFile();
                GuiPanel.this.gridShiftErrorLabel.setText(" ");
                return true;
            }
            boolean loaded = GuiPanel.this.gui.loadGridShiftFile(filePath);
            if (loaded) {
                GuiPanel.this.gridShiftErrorLabel.setText(" ");
                GuiPanel.this.forwardButton.setText(GuiPanel.this.gui.getForwardString());
                GuiPanel.this.forwardButton.setEnabled(true);
                GuiPanel.this.reverseButton.setText(GuiPanel.this.gui.getReverseString());
                GuiPanel.this.reverseButton.setEnabled(true);
            } else {
                GuiPanel.this.gridShiftErrorLabel.setText(GuiPanel.NOT_GSF);
                GuiPanel.this.forwardButton.setText("Not Loaded");
                GuiPanel.this.forwardButton.setEnabled(false);
                GuiPanel.this.reverseButton.setText("Not Loaded");
                GuiPanel.this.reverseButton.setEnabled(false);
            }
            return loaded;
        }
    }

    class FileAction
    extends AbstractAction {
        public FileAction() {
            super("File");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnVal = GuiPanel.this.fileChooser.showOpenDialog(GuiPanel.this);
            if (returnVal == 0) {
                GuiPanel.this.gui.unloadGridShiftFile();
                String filePath = GuiPanel.this.fileChooser.getSelectedFile().getAbsolutePath();
                GuiPanel.this.gridShiftFileName.setText(filePath);
                boolean loaded = GuiPanel.this.gui.loadGridShiftFile(filePath);
                if (loaded) {
                    GuiPanel.this.gridShiftErrorLabel.setText(" ");
                    GuiPanel.this.forwardButton.setText(GuiPanel.this.gui.getForwardString());
                    GuiPanel.this.forwardButton.setEnabled(true);
                    GuiPanel.this.reverseButton.setText(GuiPanel.this.gui.getReverseString());
                    GuiPanel.this.reverseButton.setEnabled(true);
                } else {
                    GuiPanel.this.gridShiftErrorLabel.setText(GuiPanel.NOT_GSF);
                    GuiPanel.this.forwardButton.setText("Not Loaded");
                    GuiPanel.this.forwardButton.setEnabled(false);
                    GuiPanel.this.reverseButton.setText("Not Loaded");
                    GuiPanel.this.reverseButton.setEnabled(false);
                }
            }
        }
    }

    class FromAction
    extends AbstractAction {
        public FromAction() {
            super("From");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiPanel.this.fromCardLayout.show(GuiPanel.this.fromCardPanel, GuiPanel.this.fromCombo.getSelectedItem().toString());
        }
    }

    class FromLatDegreeVerifier
    extends InputVerifier {
        FromLatDegreeVerifier() {
        }

        @Override
        public boolean verify(JComponent comp) {
            JTextField tf = (JTextField)comp;
            boolean ok = false;
            try {
                Number n = GuiPanel.this.degreeDecimalFormat.parse(tf.getText());
                GuiPanel.this.gridShift.setLatDegrees(n.doubleValue());
                GuiPanel.this.setFromLatValues();
                ok = true;
            }
            catch (ParseException pe) {
                ok = false;
            }
            return ok;
        }
    }

    class FromLonDegreeVerifier
    extends InputVerifier {
        FromLonDegreeVerifier() {
        }

        @Override
        public boolean verify(JComponent comp) {
            JTextField tf = (JTextField)comp;
            boolean ok = false;
            try {
                Number n = GuiPanel.this.degreeDecimalFormat.parse(tf.getText());
                GuiPanel.this.gridShift.setLonPositiveEastDegrees(n.doubleValue());
                GuiPanel.this.setFromLonValues();
                ok = true;
            }
            catch (ParseException pe) {
                ok = false;
            }
            return ok;
        }
    }

    class FromLatSecondVerifier
    extends InputVerifier {
        FromLatSecondVerifier() {
        }

        @Override
        public boolean verify(JComponent comp) {
            JTextField tf = (JTextField)comp;
            boolean ok = false;
            try {
                Number n = GuiPanel.this.secondDecimalFormat.parse(tf.getText());
                GuiPanel.this.gridShift.setLatSeconds(n.doubleValue());
                GuiPanel.this.setFromLatValues();
                ok = true;
            }
            catch (ParseException pe) {
                ok = false;
            }
            return ok;
        }
    }

    class FromLonSecondVerifier
    extends InputVerifier {
        FromLonSecondVerifier() {
        }

        @Override
        public boolean verify(JComponent comp) {
            JTextField tf = (JTextField)comp;
            boolean ok = false;
            try {
                Number n = GuiPanel.this.secondDecimalFormat.parse(tf.getText());
                GuiPanel.this.gridShift.setLonPositiveWestSeconds(n.doubleValue());
                GuiPanel.this.setFromLonValues();
                ok = true;
            }
            catch (ParseException pe) {
                ok = false;
            }
            return ok;
        }
    }

    class FromLatDMSDegVerifier
    extends InputVerifier {
        FromLatDMSDegVerifier() {
        }

        @Override
        public boolean verify(JComponent comp) {
            JTextField tf = (JTextField)comp;
            boolean ok = false;
            try {
                Number deg = GuiPanel.this.degMinDecimalFormat.parse(tf.getText());
                double sign = deg.doubleValue() < 0.0 ? -1.0 : 1.0;
                Number min = ZERO;
                if (GuiPanel.this.fromDMSMinLatText.getText().length() > 0) {
                    min = GuiPanel.this.degMinDecimalFormat.parse(GuiPanel.this.fromDMSMinLatText.getText());
                }
                Number sec = ZERO;
                if (GuiPanel.this.fromDMSSecLatText.getText().length() > 0) {
                    sec = GuiPanel.this.secondDecimalFormat.parse(GuiPanel.this.fromDMSSecLatText.getText());
                }
                GuiPanel.this.gridShift.setLatSeconds((Math.abs(deg.doubleValue()) * 3600.0 + Math.abs(min.doubleValue()) * 60.0 + Math.abs(sec.doubleValue())) * sign);
                GuiPanel.this.setFromLatValues();
                ok = true;
            }
            catch (ParseException pe) {
                ok = false;
            }
            return ok;
        }
    }

    class FromLatDMSMinVerifier
    extends InputVerifier {
        FromLatDMSMinVerifier() {
        }

        @Override
        public boolean verify(JComponent comp) {
            JTextField tf = (JTextField)comp;
            boolean ok = false;
            try {
                Number deg = ZERO;
                if (GuiPanel.this.fromDMSDegLatText.getText().length() > 0) {
                    deg = GuiPanel.this.degMinDecimalFormat.parse(GuiPanel.this.fromDMSDegLatText.getText());
                }
                double sign = deg.doubleValue() < 0.0 ? -1.0 : 1.0;
                Number min = GuiPanel.this.degMinDecimalFormat.parse(tf.getText());
                Number sec = ZERO;
                if (GuiPanel.this.fromDMSSecLatText.getText().length() > 0) {
                    sec = GuiPanel.this.secondDecimalFormat.parse(GuiPanel.this.fromDMSSecLatText.getText());
                }
                GuiPanel.this.gridShift.setLatSeconds((Math.abs(deg.doubleValue()) * 3600.0 + Math.abs(min.doubleValue()) * 60.0 + Math.abs(sec.doubleValue())) * sign);
                GuiPanel.this.setFromLatValues();
                ok = true;
            }
            catch (ParseException pe) {
                ok = false;
            }
            return ok;
        }
    }

    class FromLatDMSSecVerifier
    extends InputVerifier {
        FromLatDMSSecVerifier() {
        }

        @Override
        public boolean verify(JComponent comp) {
            JTextField tf = (JTextField)comp;
            boolean ok = false;
            try {
                Number deg = ZERO;
                if (GuiPanel.this.fromDMSDegLatText.getText().length() > 0) {
                    deg = GuiPanel.this.degMinDecimalFormat.parse(GuiPanel.this.fromDMSDegLatText.getText());
                }
                double sign = deg.doubleValue() < 0.0 ? -1.0 : 1.0;
                Number min = ZERO;
                if (GuiPanel.this.fromDMSMinLatText.getText().length() > 0) {
                    min = GuiPanel.this.degMinDecimalFormat.parse(GuiPanel.this.fromDMSMinLatText.getText());
                }
                Number sec = GuiPanel.this.secondDecimalFormat.parse(tf.getText());
                GuiPanel.this.gridShift.setLatSeconds((Math.abs(deg.doubleValue()) * 3600.0 + Math.abs(min.doubleValue()) * 60.0 + Math.abs(sec.doubleValue())) * sign);
                GuiPanel.this.setFromLatValues();
                ok = true;
            }
            catch (ParseException pe) {
                ok = false;
            }
            return ok;
        }
    }

    class FromLonDMSDegVerifier
    extends InputVerifier {
        FromLonDMSDegVerifier() {
        }

        @Override
        public boolean verify(JComponent comp) {
            JTextField tf = (JTextField)comp;
            boolean ok = false;
            try {
                Number deg = GuiPanel.this.degMinDecimalFormat.parse(tf.getText());
                double sign = deg.doubleValue() < 0.0 ? 1.0 : -1.0;
                Number min = ZERO;
                if (GuiPanel.this.fromDMSMinLonText.getText().length() > 0) {
                    min = GuiPanel.this.degMinDecimalFormat.parse(GuiPanel.this.fromDMSMinLonText.getText());
                }
                Number sec = ZERO;
                if (GuiPanel.this.fromDMSSecLonText.getText().length() > 0) {
                    sec = GuiPanel.this.secondDecimalFormat.parse(GuiPanel.this.fromDMSSecLonText.getText());
                }
                GuiPanel.this.gridShift.setLonPositiveWestSeconds((Math.abs(deg.doubleValue()) * 3600.0 + Math.abs(min.doubleValue()) * 60.0 + Math.abs(sec.doubleValue())) * sign);
                GuiPanel.this.setFromLonValues();
                ok = true;
            }
            catch (ParseException pe) {
                ok = false;
            }
            return ok;
        }
    }

    class FromLonDMSMinVerifier
    extends InputVerifier {
        FromLonDMSMinVerifier() {
        }

        @Override
        public boolean verify(JComponent comp) {
            JTextField tf = (JTextField)comp;
            boolean ok = false;
            try {
                Number deg = ZERO;
                if (GuiPanel.this.fromDMSDegLonText.getText().length() > 0) {
                    deg = GuiPanel.this.degMinDecimalFormat.parse(GuiPanel.this.fromDMSDegLonText.getText());
                }
                double sign = deg.doubleValue() < 0.0 ? 1.0 : -1.0;
                Number min = GuiPanel.this.degMinDecimalFormat.parse(tf.getText());
                Number sec = ZERO;
                if (GuiPanel.this.fromDMSSecLonText.getText().length() > 0) {
                    sec = GuiPanel.this.secondDecimalFormat.parse(GuiPanel.this.fromDMSSecLonText.getText());
                }
                GuiPanel.this.gridShift.setLonPositiveWestSeconds((Math.abs(deg.doubleValue()) * 3600.0 + Math.abs(min.doubleValue()) * 60.0 + Math.abs(sec.doubleValue())) * sign);
                GuiPanel.this.setFromLonValues();
                ok = true;
            }
            catch (ParseException pe) {
                ok = false;
            }
            return ok;
        }
    }

    class FromLonDMSSecVerifier
    extends InputVerifier {
        FromLonDMSSecVerifier() {
        }

        @Override
        public boolean verify(JComponent comp) {
            JTextField tf = (JTextField)comp;
            boolean ok = false;
            try {
                Number deg = ZERO;
                if (GuiPanel.this.fromDMSDegLonText.getText().length() > 0) {
                    deg = GuiPanel.this.degMinDecimalFormat.parse(GuiPanel.this.fromDMSDegLonText.getText());
                }
                double sign = deg.doubleValue() < 0.0 ? 1.0 : -1.0;
                Number min = ZERO;
                if (GuiPanel.this.fromDMSMinLonText.getText().length() > 0) {
                    min = GuiPanel.this.degMinDecimalFormat.parse(GuiPanel.this.fromDMSMinLonText.getText());
                }
                Number sec = GuiPanel.this.secondDecimalFormat.parse(tf.getText());
                GuiPanel.this.gridShift.setLonPositiveWestSeconds((Math.abs(deg.doubleValue()) * 3600.0 + Math.abs(min.doubleValue()) * 60.0 + Math.abs(sec.doubleValue())) * sign);
                GuiPanel.this.setFromLonValues();
                ok = true;
            }
            catch (ParseException pe) {
                ok = false;
            }
            return ok;
        }
    }

    class ToAction
    extends AbstractAction {
        public ToAction() {
            super("To");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiPanel.this.toCardLayout.show(GuiPanel.this.toCardPanel, GuiPanel.this.toCombo.getSelectedItem().toString());
        }
    }

    class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            super("Forward");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (GuiPanel.this.gui.gridShiftForward(GuiPanel.this.gridShift)) {
                    GuiPanel.this.setToValues();
                    GuiPanel.this.message.setText(GuiPanel.this.gridShift.getSubGridName());
                } else {
                    GuiPanel.this.clearToValues();
                    GuiPanel.this.message.setText("Coordinate not in Grid Shift File");
                }
            }
            catch (IOException ioe) {
                GuiPanel.this.clearToValues();
                GuiPanel.this.message.setText("IO Exception : " + ioe.getMessage());
            }
        }
    }

    class ReverseAction
    extends AbstractAction {
        public ReverseAction() {
            super("Reverse");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (GuiPanel.this.gui.gridShiftReverse(GuiPanel.this.gridShift)) {
                    GuiPanel.this.setToValues();
                    GuiPanel.this.message.setText(GuiPanel.this.gridShift.getSubGridName());
                } else {
                    GuiPanel.this.clearToValues();
                    GuiPanel.this.message.setText("Coordinate not in Grid Shift File");
                }
            }
            catch (IOException ioe) {
                GuiPanel.this.clearToValues();
                GuiPanel.this.message.setText("IO Exception : " + ioe.getMessage());
            }
        }
    }
}

