/*
 * Decompiled with CFR 0.152.
 */
package au.com.objectix.jgridshift.sample.gui;

import au.com.objectix.jgridshift.GridShift;
import au.com.objectix.jgridshift.GridShiftFile;
import au.com.objectix.jgridshift.sample.gui.AboutDialog;
import au.com.objectix.jgridshift.sample.gui.GuiPanel;
import au.com.objectix.jgridshift.sample.gui.SubGridTreeModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;

public class Gui
extends JFrame {
    public static final String TITLE = "jGridShift";
    public static final String NOT_LOADED = "Not Loaded";
    private GridShiftFile gridShiftFile = new GridShiftFile();
    private JTree tree;
    private File userPropertiesFile;
    private Properties userProperties = new Properties();

    public Gui() throws Exception {
        super(TITLE);
        JMenuBar menuBar = new JMenuBar();
        JMenu helpMenu = new JMenu("Help");
        helpMenu.add(new AboutAction());
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
        this.tree = new JTree(new SubGridTreeModel());
        String userHome = System.getProperty("user.home");
        this.userPropertiesFile = new File(userHome, "jgridshift.properties");
        if (!this.userPropertiesFile.exists()) {
            this.userPropertiesFile.createNewFile();
        }
        this.userProperties.load(new FileInputStream(this.userPropertiesFile));
        String gridShiftFileName = (String)this.userProperties.get("gridShiftFile");
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setPreferredSize(new Dimension(100, 150));
        GridBagLayout gridbag = new GridBagLayout();
        GuiPanel guiPanel = new GuiPanel(gridShiftFileName, gridbag, this);
        JSplitPane splitPane = new JSplitPane(0, guiPanel, scrollPane);
        this.getContentPane().add((Component)splitPane, "Center");
    }

    public boolean loadGridShiftFile(String filePath) {
        boolean loaded = false;
        try {
            this.gridShiftFile.loadGridShiftFile(new RandomAccessFile(filePath, "r"));
            loaded = true;
            this.tree.setModel(new SubGridTreeModel(this.gridShiftFile.getSubGridTree()));
            this.userProperties.setProperty("gridShiftFile", filePath);
            try {
                this.userProperties.store(new FileOutputStream(this.userPropertiesFile), null);
            }
            catch (IOException iOException) {}
        }
        catch (Exception ex) {
            this.tree.setModel(new SubGridTreeModel());
        }
        return loaded;
    }

    public void unloadGridShiftFile() {
        try {
            this.gridShiftFile.unload();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean gridShiftForward(GridShift gs) throws IOException {
        return this.gridShiftFile.gridShiftForward(gs);
    }

    public boolean gridShiftReverse(GridShift gs) throws IOException {
        return this.gridShiftFile.gridShiftReverse(gs);
    }

    public String getForwardString() {
        if (this.gridShiftFile.isLoaded()) {
            return this.gridShiftFile.getFromEllipsoid() + " -> " + this.gridShiftFile.getToEllipsoid();
        }
        return NOT_LOADED;
    }

    public String getReverseString() {
        if (this.gridShiftFile.isLoaded()) {
            return this.gridShiftFile.getToEllipsoid() + " -> " + this.gridShiftFile.getFromEllipsoid();
        }
        return NOT_LOADED;
    }

    public static void main(String[] args) {
        try {
            Gui frame = new Gui();
            frame.setDefaultCloseOperation(2);
            frame.pack();
            frame.setVisible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super("About");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialog dialog = new AboutDialog(Gui.this);
            dialog.pack();
            dialog.show();
            dialog.dispose();
        }
    }
}

