/*
 * Decompiled with CFR 0.152.
 */
package com.ezware.dialog.task;

import com.ezware.dialog.task.CommandLink;
import com.ezware.dialog.task.TaskDialog;
import com.ezware.dialog.task.TaskDialogs;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public class TaskDialogsDemo
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JButton btInform = new JButton("inform");
    private final JButton btWarn = new JButton("warn");
    private final JButton btRadioChoice = new JButton("radioChoice");
    private final JButton btChoice = new JButton("choice");
    private final JButton btException = new JButton("showException");
    private final JButton btSimple = new JButton("simple message");
    private final JButton btInput = new JButton("input");
    private final JComboBox cbLocales = new JComboBox();
    private final JLabel lblDefaultLocale = new JLabel("Default Locale");

    public TaskDialogsDemo() {
        this.createLayout();
        DisplayableLocale[] locales = new DisplayableLocale[]{new DisplayableLocale(), new DisplayableLocale(Locale.GERMANY), new DisplayableLocale("ES"), new DisplayableLocale("PT"), new DisplayableLocale("pt", "BR"), new DisplayableLocale(Locale.FRANCE), new DisplayableLocale(Locale.ITALY), new DisplayableLocale("PL"), new DisplayableLocale(Locale.CHINA)};
        this.cbLocales.setModel(new DefaultComboBoxModel<DisplayableLocale>(locales));
        this.cbLocales.setMaximumRowCount(locales.length);
        this.cbLocales.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Locale.setDefault(((DisplayableLocale)TaskDialogsDemo.this.cbLocales.getSelectedItem()).getLocale());
            }
        });
        this.btSimple.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskDialog dlg = new TaskDialog(null, "Task Dialog");
                dlg.setInstruction("This Simple Task Dialog");
                dlg.setText("Here is task dialog content");
                dlg.show();
            }
        });
        this.btInform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskDialogs.inform(null, "You've won!", "The game is over with the 15:3 score");
            }
        });
        this.btInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Your input: " + TaskDialogs.input(null, "Enter your name", "or any other text if you prefer", "Steve Jobs"));
            }
        });
        this.btWarn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskDialogs.isConfirmed(null, "Are you sure you want to quit?", "Please do not quit yet!");
            }
        });
        this.btRadioChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int choice = TaskDialogs.radioChoice(null, "You've got selection to make", "Go ahead", 1, "Yes", "No", "May be");
                System.out.println("Your choice is " + choice);
            }
        });
        this.btChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int choice = TaskDialogs.choice(null, "What do you want to do with your game in\nprogress?", "", 1, new CommandLink("Exit and save my game", "Save your game in progress, then exit. This will\noverwrite any previosely saved games."), new CommandLink("Exit and don't save", "Exit without saving your game. This is counted\nas a loss in your statistics."), new CommandLink("Don't exit", "Return to your game progress"));
                System.out.println("Your choice is " + choice);
            }
        });
        this.btException.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    new BigDecimal("seven");
                }
                catch (Throwable ex) {
                    TaskDialogs.showException(ex);
                }
            }
        });
    }

    private void createLayout() {
        this.setLayout((LayoutManager)new MigLayout("", "[][135px]15px[135px]15px[135px,grow]", "[pref!][20px][23px][23px][]"));
        this.add((Component)this.lblDefaultLocale, "cell 2 0,alignx trailing,aligny baseline");
        this.add((Component)this.cbLocales, "cell 3 0,growx,aligny baseline");
        this.add((Component)this.btSimple, "cell 1 2,growx,aligny top");
        this.add((Component)this.btInform, "cell 1 3,growx,aligny top");
        this.add((Component)this.btWarn, "cell 1 4,growx,aligny top");
        this.add((Component)this.btRadioChoice, "cell 2 2,growx,aligny top");
        this.add((Component)this.btChoice, "cell 2 3,growx,aligny top");
        this.add((Component)this.btException, "cell 3 2,growx,aligny top");
        this.add((Component)this.btInput, "cell 3 3,growx,aligny top");
    }

    public static void main(String[] args) {
        System.out.println("Resolution: " + Toolkit.getDefaultToolkit().getScreenResolution());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                JFrame f = new JFrame("Task Dialog Demo");
                f.setDefaultCloseOperation(3);
                f.setContentPane(new TaskDialogsDemo());
                f.pack();
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }
        });
    }

    private static class DisplayableLocale {
        private final Locale locale;

        public DisplayableLocale(String id) {
            this.locale = id == null ? TaskDialogsDemo.getDefaultLocale() : new Locale(id.toLowerCase(), id.toUpperCase());
        }

        public DisplayableLocale(String language, String country) {
            this.locale = new Locale(language.toLowerCase(), country.toUpperCase());
        }

        public DisplayableLocale() {
            this((Locale)null);
        }

        public DisplayableLocale(Locale locale) {
            this.locale = locale == null ? TaskDialogsDemo.getDefaultLocale() : locale;
        }

        public String toString() {
            return this.locale.getDisplayName();
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

