/*
 * Decompiled with CFR 0.152.
 */
package com.ezware.dialog.task;

import com.ezware.dialog.task.TaskDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SimpleTaskDialogDemo {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                String title = "Exit";
                String instruction = "Exiting TaskDialog";
                String text = "Are you sure you want to exit ?";
                TaskDialog dlg = new TaskDialog(null, "Exit");
                dlg.setInstruction("Exiting TaskDialog");
                dlg.setText("Are you sure you want to exit ?");
                dlg.setIcon(TaskDialog.StandardIcon.QUESTION);
                JLabel commentTitle = new JLabel("Tell us why you are exiting TaskDialog");
                JTextArea comment = new JTextArea(5, 100);
                JCheckBox disableComments = new JCheckBox("don't ask me to comment again");
                disableComments.setOpaque(false);
                JPanel panel = new JPanel(new BorderLayout());
                panel.setOpaque(false);
                panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
                panel.add((Component)commentTitle, "North");
                panel.add(new JScrollPane(comment));
                panel.add((Component)disableComments, "South");
                dlg.getDetails().setExpandableComponent(panel);
                dlg.getDetails().setAlwaysExpanded(true);
                dlg.setCommands(TaskDialog.StandardCommand.OK.derive(TaskDialog.makeKey("Yes")), TaskDialog.StandardCommand.CANCEL.derive(TaskDialog.makeKey("No")));
                dlg.getFooter().setCheckBoxText("don't ask me again");
                dlg.getFooter().setCheckBoxSelected(false);
                TaskDialog.Command result = dlg.show();
                boolean exit = result.equals(TaskDialog.StandardCommand.OK);
                boolean disableConfirm = dlg.getFooter().isCheckBoxSelected();
                System.out.println("exit = " + exit);
                System.out.println("disableConfirm = " + disableConfirm);
                System.out.println("disableComments = " + disableComments.isSelected());
                System.out.println("comment = " + comment.getText());
                System.exit(0);
            }
        });
    }
}

