/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.service.registry;

import de.riwagis.service.ServiceMData;
import de.riwagis.service.registry.ServiceRegistryLogin;
import de.riwagis.service.registry.ServiceRegistryMap;
import de.riwagis.service.registry.ServiceRegistryMobile;
import de.riwagis.service.registry.ServiceRegistryModule;
import de.riwagis.service.registry.ServiceRegistryReports;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ServiceRegistry {
    private static final List<ServiceMData> lstServices = new ArrayList<ServiceMData>();

    private ServiceRegistry() {
    }

    public static boolean addService(ServiceMData svc) {
        return lstServices.add(svc);
    }

    public static Iterator<ServiceMData> getServices() {
        return lstServices.iterator();
    }

    public static ServiceMData getService(String name, int version) {
        Iterator<ServiceMData> i = ServiceRegistry.getServices();
        while (i.hasNext()) {
            ServiceMData svc = i.next();
            if (!svc.getName().equals(name) || svc.getVersion() != version) continue;
            return svc;
        }
        return null;
    }

    static {
        ServiceRegistry.addService(ServiceRegistryLogin.generateLoginServiceV0());
        ServiceRegistry.addService(ServiceRegistryModule.generateModuleServiceV0());
        ServiceRegistry.addService(ServiceRegistryModule.generateMapServiceV0());
        ServiceRegistry.addService(ServiceRegistryModule.generateSystemServiceV0());
        ServiceRegistry.addService(ServiceRegistryModule.generateDialogServiceV0());
        ServiceRegistry.addService(ServiceRegistryModule.generateDialogFileServiceV0());
        ServiceRegistry.addService(ServiceRegistryModule.generateModuleFileServiceV0());
        ServiceRegistry.addService(ServiceRegistryModule.generateImportServiceV0());
        ServiceRegistry.addService(ServiceRegistryModule.generateExportServiceV0());
        ServiceRegistry.addService(ServiceRegistryReports.generateJasperServiceV0());
        ServiceRegistry.addService(ServiceRegistryReports.generateRTFTemplateServiceV0());
        ServiceRegistry.addService(ServiceRegistryReports.generateExportServiceV0());
        ServiceRegistry.addService(ServiceRegistryReports.generateTextExportServiceV0());
        ServiceRegistry.addService(ServiceRegistryMobile.generateMobileFeatureServiceV0());
        ServiceRegistry.addService(ServiceRegistryMap.generateFeatureServiceV0());
        ServiceRegistry.addService(ServiceRegistryMap.generateVectorTilesServiceV0());
    }
}

