/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.bsh;

import bsh.Interpreter;
import de.riwagis.util.Config;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BshStringBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(BshStringBuilder.class);
    private static Format fmtColumnParser = SimpleDateFormat.getDateInstance(2, Config.LOCALE);
    public static final BshStringBuilder EMPTY_BSHBUILDER = new BshStringBuilder(){

        @Override
        public String getString() {
            return Objects.toString(this.getValue(), "");
        }
    };
    private Object value = "";

    protected final Object getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Set value: '%s'", value));
        }
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getDate(Date dateValue) {
        if (dateValue == null) {
            return "";
        }
        return fmtColumnParser.format(dateValue);
    }

    public String getDate(java.sql.Date dateValue) {
        if (dateValue == null) {
            return "";
        }
        return this.getDate(new Date(dateValue.getTime()));
    }

    public String getFormatString(double dblNumber, String strFormat) {
        DecimalFormat dfmt = new DecimalFormat(strFormat);
        return dfmt.format(BigDecimal.valueOf(dblNumber));
    }

    public abstract String getString();

    public static BshStringBuilder getInstance(String strBsh) throws Exception {
        Interpreter ip = new Interpreter();
        Object obj = ip.eval(String.format("import java.util.*;import java.util.concurrent.locks.*;import de.riwagis.util.Support;new de.riwagis.util.bsh.BshStringBuilder(){  public String getString(){    return \"\" + %s;  }};", StringUtils.defaultIfEmpty((CharSequence)strBsh, (CharSequence)"\"\"")));
        return (BshStringBuilder)obj;
    }
}

