/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.sentence;

import net.sf.marineapi.nmea.util.CompassPoint;

public class PPMPosition {
    private double easting;
    private double northing;
    private double altitude = 0.0;

    public PPMPosition(double easting, double northing) {
        this.setEasting(easting);
        this.setNorthing(northing);
    }

    public PPMPosition(double easting, double northing, double alt) {
        this(easting, northing);
        this.altitude = alt;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public final void setEasting(double easting) {
        this.easting = easting;
    }

    public final void setNorthing(double northing) {
        this.northing = northing;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(String.format("%02.04f", Math.abs(this.getEasting())));
        sb.append(" ");
        sb.append(this.getEastingHemisphere().toChar());
        sb.append(", ");
        sb.append(String.format("%03.04f", Math.abs(this.getNorthing())));
        sb.append(" ");
        sb.append(this.getNorthingHemisphere().toChar());
        sb.append(", ");
        sb.append(this.getAltitude());
        sb.append(" m]");
        return sb.toString();
    }

    public CompassPoint getEastingHemisphere() {
        return this.getEasting() < 0.0 ? CompassPoint.WEST : CompassPoint.EAST;
    }

    public CompassPoint getNorthingHemisphere() {
        return this.getNorthing() < 0.0 ? CompassPoint.SOUTH : CompassPoint.NORTH;
    }
}

