/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.sf.marineapi.nmea.parser.PPMParser;
import net.sf.marineapi.nmea.parser.ParseException;
import net.sf.marineapi.nmea.parser.SentenceFactory;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.PPMPosition;
import net.sf.marineapi.nmea.util.CompassPoint;

public class PPMParserUtils {
    public static PPMPosition parsePosition(String eastingValue, char eastingCompassChar, String northingValue, char northingCompassChar) throws ParseException {
        CompassPoint eastingCompass = PPMParserUtils.parseHemisphere(eastingCompassChar);
        CompassPoint northingCompass = PPMParserUtils.parseHemisphere(northingCompassChar);
        double easting = PPMParserUtils.parseOrdinate(eastingValue);
        double northing = PPMParserUtils.parseOrdinate(northingValue);
        if (eastingCompass.equals((Object)CompassPoint.SOUTH)) {
            easting = -easting;
        }
        if (northingCompass.equals((Object)CompassPoint.WEST)) {
            northing = -northing;
        }
        return new PPMPosition(easting, northing);
    }

    public static double parseOrdinate(String fieldValue) throws ParseException {
        DecimalFormat df = new DecimalFormat("#0.000");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        try {
            return df.parse(fieldValue).doubleValue();
        }
        catch (java.text.ParseException ex) {
            throw new ParseException(String.format("unable to parse '%s': %s", fieldValue, ex.getMessage()), (Throwable)ex);
        }
    }

    public static CompassPoint parseHemisphere(char hemChar) {
        return CompassPoint.valueOf((char)hemChar);
    }

    public static void setPositionValues(SentenceParser x, PPMPosition p, int latIndex, int latHemIndex, int lonIndex, int lonHemIndex) {
        x.setStringValue(latIndex, PPMParserUtils.formatOrdinate(Math.abs(p.getEasting())));
        x.setStringValue(lonIndex, PPMParserUtils.formatOrdinate(Math.abs(p.getNorthing())));
        x.setCharValue(latHemIndex, p.getEastingHemisphere().toChar());
        x.setCharValue(lonHemIndex, p.getNorthingHemisphere().toChar());
    }

    public static String formatOrdinate(double ordinateValue) {
        DecimalFormat df = new DecimalFormat("#0.000");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        return df.format(ordinateValue);
    }

    public static void registerPPMParser() {
        SentenceFactory.getInstance().registerParser("PPM", PPMParser.class);
    }

    private PPMParserUtils() {
    }
}

