/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.PPMParserUtils;
import net.sf.marineapi.nmea.parser.ParseException;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.PPMPosition;
import net.sf.marineapi.nmea.sentence.PPMSentence;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.GpsFixQuality;
import net.sf.marineapi.nmea.util.Time;
import net.sf.marineapi.nmea.util.Units;

public class PPMParser
extends SentenceParser
implements PPMSentence {
    private static final int UTC_TIME = 0;
    private static final int EASTING_VALUE = 1;
    private static final int EASTING_HEMISPHERE = 2;
    private static final int NORTHING_VALUE = 3;
    private static final int NORTHING_HEMISPHERE = 4;
    private static final int FIX_QUALITY = 5;
    private static final int SATELLITES_IN_USE = 6;
    private static final int HORIZONTAL_DILUTION = 7;
    private static final int ALTITUDE = 8;
    private static final int ALTITUDE_UNITS = 9;
    private static final int GEOIDAL_HEIGHT = 10;
    private static final int HEIGHT_UNITS = 11;
    private static final int DGPS_AGE = 12;
    private static final int DGPS_STATION_ID = 13;

    public PPMParser(String nmea) {
        super(nmea, "PPM");
    }

    public PPMParser(TalkerId talker) {
        super(talker, "PPM", 14);
    }

    public boolean isProprietary() {
        return true;
    }

    @Override
    public double getAltitude() {
        return this.getDoubleValue(8);
    }

    @Override
    public Units getAltitudeUnits() {
        char ch = this.getCharValue(9);
        if (ch != 'M') {
            String msg = "Invalid altitude unit indicator: %s";
            throw new ParseException(String.format(msg, Character.valueOf(ch)));
        }
        return Units.valueOf((char)ch);
    }

    @Override
    public double getDgpsAge() {
        return this.getDoubleValue(12);
    }

    @Override
    public String getDgpsStationId() {
        return this.getStringValue(13);
    }

    @Override
    public GpsFixQuality getFixQuality() {
        return GpsFixQuality.valueOf((int)this.getIntValue(5));
    }

    @Override
    public double getGeoidalHeight() {
        return this.getDoubleValue(10);
    }

    @Override
    public Units getGeoidalHeightUnits() {
        return Units.valueOf((char)this.getCharValue(11));
    }

    @Override
    public double getHorizontalDOP() {
        return this.getDoubleValue(7);
    }

    public static int getEastinge() {
        return 2;
    }

    @Override
    public PPMPosition getPosition() throws ParseException {
        PPMPosition pos = PPMParserUtils.parsePosition(this.getStringValue(1), this.getCharValue(2), this.getStringValue(3), this.getCharValue(4));
        if (this.hasValue(8) && this.hasValue(9)) {
            double alt = this.getAltitude();
            if (this.getAltitudeUnits().equals((Object)Units.FEET)) {
                alt /= 0.3048;
            }
            pos.setAltitude(alt);
        }
        return pos;
    }

    @Override
    public int getSatelliteCount() {
        return this.getIntValue(6);
    }

    public Time getTime() {
        String str = this.getStringValue(0);
        return new Time(str);
    }

    @Override
    public void setAltitude(double alt) {
        this.setDoubleValue(8, alt, 1, 1);
    }

    @Override
    public void setAltitudeUnits(Units unit) {
        this.setCharValue(9, unit.toChar());
    }

    @Override
    public void setDgpsAge(double age) {
        this.setDoubleValue(12, age, 1, 1);
    }

    @Override
    public void setDgpsStationId(String id) {
        this.setStringValue(13, id);
    }

    @Override
    public void setFixQuality(GpsFixQuality quality) {
        this.setIntValue(5, quality.toInt());
    }

    @Override
    public void setGeoidalHeight(double height) {
        this.setDoubleValue(10, height, 1, 1);
    }

    @Override
    public void setGeoidalHeightUnits(Units unit) {
        this.setCharValue(11, unit.toChar());
    }

    @Override
    public void setHorizontalDOP(double hdop) {
        this.setDoubleValue(7, hdop, 1, 1);
    }

    @Override
    public void setPosition(PPMPosition pos) {
        PPMParserUtils.setPositionValues(this, pos, 1, 2, 3, 4);
        this.setAltitude(pos.getAltitude());
        this.setAltitudeUnits(Units.METER);
    }

    public void setTime(Time t) {
        this.setStringValue(0, t.toString());
    }
}

