/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.nmea;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSReaderSupport {
    private static final Logger LOG = LoggerFactory.getLogger(GPSReaderSupport.class);

    public static boolean checkNMEAChecksum(String s) {
        try {
            boolean dollarSign = false;
            boolean asteriskSign = false;
            int val = 0;
            StringBuilder cs = new StringBuilder();
            byte[] b = s.getBytes();
            for (int i = 0; i < b.length; ++i) {
                byte currByte = b[i];
                if (dollarSign) {
                    if (currByte == 42) {
                        asteriskSign = true;
                        continue;
                    }
                    if (!asteriskSign) {
                        val = (byte)(val ^ currByte);
                        continue;
                    }
                    cs.append(s.charAt(i));
                    continue;
                }
                if (currByte != 36) continue;
                dollarSign = true;
            }
            int csInt = Integer.parseInt(cs.toString(), 16);
            return asteriskSign && dollarSign && val == csInt;
        }
        catch (Exception ex) {
            LOG.warn("error checking nmea checksum: " + ex.getMessage());
            return false;
        }
    }

    private GPSReaderSupport() {
    }
}

