/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.nmea;

import de.riwagis.util.io.rxtx.ComPortConfiguration;
import de.riwagis.util.io.rxtx.ComPortSupport;
import gnu.io.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import ocss.nmea.api.NMEAEvent;
import ocss.nmea.api.NMEAReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSReaderReader
extends NMEAReader {
    private static final Logger LOG = LoggerFactory.getLogger(GPSReaderReader.class);
    private SerialPort sp = null;

    public GPSReaderReader(Collection<?> al) {
        super(new ArrayList(al));
        this.setDaemon(true);
        this.setName("GPSReaderReader");
    }

    public GPSReaderReader(Collection<?> al, ComPortConfiguration config) throws IOException {
        this(al);
        this.startReading(ComPortSupport.openCommPort(config));
    }

    public final void startReading(SerialPort sp) {
        this.sp = sp;
    }

    public void stopReading() {
        SerialPort spSave = this.sp;
        this.sp = null;
        if (spSave != null) {
            LOG.info(String.format("Closing serial port (%s, %d)", spSave.getName(), spSave.getBaudRate()));
            spSave.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.stopReading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        try (InputStream theInput = null;){
            byte[] buffer = new byte[4096];
            while (this.canRead()) {
                if (theInput == null) {
                    if (this.sp != null) {
                        LOG.info(String.format("Start Reading serial port (%s, %d)", this.sp.getName(), this.sp.getBaudRate()));
                        theInput = this.sp.getInputStream();
                    }
                } else if (this.sp == null) {
                    LOG.info(String.format("Stop  Reading serial port", new Object[0]));
                    theInput.close();
                    theInput = null;
                }
                if (theInput != null) {
                    int bytesRead = theInput.read(buffer);
                    if (bytesRead == -1) break;
                    if (bytesRead > 0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(String.format("Read %s characters", bytesRead));
                        }
                        int nn = bytesRead;
                        for (int i = 0; i < Math.min(buffer.length, bytesRead); ++i) {
                            if (buffer[i] != 0) continue;
                            nn = i;
                            break;
                        }
                        byte[] toPrint = new byte[nn];
                        System.arraycopy(buffer, 0, toPrint, 0, nn);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(String.format("NMEA: %s", new String(toPrint)));
                        }
                        super.fireDataRead(new NMEAEvent((Object)this, new String(toPrint)));
                    }
                } else {
                    Thread.sleep(100L);
                }
                Thread.sleep(10L);
            }
            LOG.info(String.format("Stop Reading serial port... (%s)", this.sp));
        }
        catch (IOException | InterruptedException e) {
            LOG.error(String.format("Error reading port: %s", e.getMessage()), (Throwable)e);
        }
        this.stopReading();
    }

    public boolean canRead() {
        return super.canRead();
    }

    public boolean isCanReadGPS() {
        return this.sp != null;
    }
}

