/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.io.rxtx;

import de.riwagis.util.io.rxtx.ComPortConfiguration;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComPortSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ComPortSupport.class);

    public static SerialPort openCommPort(ComPortConfiguration config) throws IOException {
        RXTXPort thePort;
        CommPortIdentifier com;
        try {
            com = CommPortIdentifier.getPortIdentifier((String)config.getComPortName());
        }
        catch (NoSuchPortException nspe) {
            throw new IOException(nspe.getMessage(), nspe);
        }
        int portType = com.getPortType();
        if (portType != 1) {
            throw new IOException("Only serial ports allowed");
        }
        try {
            thePort = com.open("PortOpener", 10);
        }
        catch (PortInUseException piue) {
            throw new IOException(piue.getMessage(), piue);
        }
        SerialPort sp = (SerialPort)thePort;
        try {
            sp.setSerialPortParams(config.getBaudrate().intValue(), config.getAmountDataBits().intValue(), config.getAmountStopBits().intValue(), config.getAmountParityBits().intValue());
        }
        catch (UnsupportedCommOperationException ucoe) {
            throw new IOException(ucoe.getMessage(), ucoe);
        }
        return sp;
    }

    public static File createTmpDir(String prefix, String suffix) throws IOException {
        return ComPortSupport.createTmpDir(prefix, suffix, null);
    }

    public static File createTmpDir(String prefix, String suffix, File dir) throws IOException {
        File tmpDir = File.createTempFile(prefix, suffix, dir);
        tmpDir.delete();
        tmpDir.mkdirs();
        return tmpDir;
    }

    private ComPortSupport() {
    }
}

