/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.concurrent;

import com.opencsv.bean.concurrent.AccumulateCsvResults;
import com.opencsv.bean.concurrent.OrderedObject;
import com.opencsv.exceptions.CsvException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class IntolerantThreadPoolExecutor<T>
extends ThreadPoolExecutor {
    protected final BlockingQueue<OrderedObject<T>> resultQueue = new LinkedBlockingQueue<OrderedObject<T>>();
    protected final BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue = new LinkedBlockingQueue<OrderedObject<CsvException>>();
    private ConcurrentNavigableMap<Long, T> resultantBeansMap = null;
    private ConcurrentNavigableMap<Long, CsvException> thrownExceptionsMap = null;
    protected AccumulateCsvResults<T> accumulateThread = null;
    private final boolean orderedResults;
    private Throwable terminalException;

    IntolerantThreadPoolExecutor(boolean orderedResults) {
        super(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), Long.MAX_VALUE, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>());
        this.orderedResults = orderedResults;
    }

    public void prepare() {
        this.prestartAllCoreThreads();
        if (this.orderedResults) {
            this.resultantBeansMap = new ConcurrentSkipListMap<Long, T>();
            this.thrownExceptionsMap = new ConcurrentSkipListMap<Long, CsvException>();
            this.accumulateThread = new AccumulateCsvResults<T>(this.resultQueue, this.thrownExceptionsQueue, this.resultantBeansMap, this.thrownExceptionsMap);
            this.accumulateThread.start();
        }
    }

    public void complete() throws InterruptedException {
        super.shutdown();
        this.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        if (this.accumulateThread != null) {
            this.accumulateThread.setMustStop(true);
            this.accumulateThread.join();
        }
        if (this.terminalException != null) {
            throw new RejectedExecutionException();
        }
    }

    public Stream<T> resultStream() {
        return this.resultantBeansMap != null ? this.resultantBeansMap.values().stream() : this.resultQueue.stream().filter(Objects::nonNull).map(OrderedObject::getElement);
    }

    public List<CsvException> getCapturedExceptions() {
        return this.thrownExceptionsMap == null ? this.thrownExceptionsQueue.stream().filter(Objects::nonNull).map(OrderedObject::getElement).collect(Collectors.toList()) : new ArrayList<CsvException>(this.thrownExceptionsMap.values());
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.accumulateThread != null) {
            this.accumulateThread.setMustStop(true);
        }
        return super.shutdownNow();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t != null) {
            this.terminalException = t.getCause() != null ? t.getCause() : t;
            this.shutdownNow();
        }
    }

    public Throwable getTerminalException() {
        return this.terminalException;
    }
}

