/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.svg;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SVGSupport.class);
    private static final float FILLSHAPES4PRINT_RASTERSCALE = 2.0f;
    private static final int FILLSHAPES4PRINT_MAXSYMWIDTH = 750;
    private static final int FILLSHAPES4PRINT_MAXIMGSIZE = 1500;
    private static final int OPAQUE = 255;
    private static final double MAX_TRANSPARENCY_DOUBLE = 255.0;
    private static final float MAX_TRANSPARENCY_FLOAT = 255.0f;

    private SVGSupport() {
    }

    public static Document readSVG(String uri) {
        try {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
            Document doc = f.createDocument(uri);
            return doc;
        }
        catch (IOException ex) {
            LOG.error(String.format("Error reading SVG from URI: '%s'", uri), (Throwable)ex);
            return null;
        }
    }

    public static Document readSVG(String uri, InputStream in) {
        try {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
            Document doc = f.createDocument(uri, in);
            return doc;
        }
        catch (IOException ex) {
            LOG.error(String.format("Error reading SVG from Stream: '%s'", uri), (Throwable)ex);
            return null;
        }
    }

    public static void replaceColor(Document doc, Color stroke, Color fill) {
        SVGSupport.replaceColor(doc, stroke, fill, 255, true);
    }

    public static void replaceColor(Document doc, Color stroke, Color fill, int alphaOverwrite, boolean replaceOpacity) {
        NodeList lstChilds = doc.getChildNodes();
        for (int i = 0; i < lstChilds.getLength(); ++i) {
            Node child = lstChilds.item(i);
            if (child.getNodeType() != 1) continue;
            SVGSupport.replaceColor((Element)child, stroke, fill, alphaOverwrite, replaceOpacity);
        }
    }

    public static GraphicsNode getGraphicsNode(Document doc, Rectangle2D rect) {
        UserAgentAdapter agent = new UserAgentAdapter();
        BridgeContext bridgeContext = new BridgeContext((UserAgent)agent);
        bridgeContext.setDynamic(true);
        GVTBuilder builder = new GVTBuilder();
        GraphicsNode graphicsNode = builder.build(bridgeContext, doc);
        if (rect != null) {
            rect.setRect(0.0, 0.0, bridgeContext.getDocumentSize().getWidth(), bridgeContext.getDocumentSize().getHeight());
        }
        return graphicsNode;
    }

    private static void replaceColor(Element elem, Color stroke, Color areaFill, int alphaOverwrite, boolean replaceOpacity) {
        NamedNodeMap mapAtt = elem.getAttributes();
        Node styleAtt = mapAtt.getNamedItem("style");
        Color fill = "marker".equals(elem.getNodeName()) ? stroke : areaFill;
        if (styleAtt != null) {
            String strCss = styleAtt.getFirstChild().getNodeValue();
            Map<String, String> cssStyles = SVGSupport.mapCSSStyleStringToMap(strCss);
            cssStyles.compute("fill", (k, v) -> {
                if ("none".equals(v)) {
                    return v;
                }
                return SVGSupport.replaceSVGColor(fill, v);
            });
            cssStyles.compute("stroke", (k, v) -> SVGSupport.replaceSVGColor(stroke, v));
            cssStyles.compute("fill-opacity", (k, v) -> SVGSupport.replaceOpacity(v, fill, alphaOverwrite, replaceOpacity));
            cssStyles.compute("stroke-opacity", (k, v) -> SVGSupport.replaceOpacity(v, stroke, alphaOverwrite, replaceOpacity));
            String cssStyle = SVGSupport.mapCSSStyleMapToString(cssStyles);
            styleAtt.getFirstChild().setNodeValue(cssStyle);
        }
        NodeList lstChilds = elem.getChildNodes();
        for (int i = 0; i < lstChilds.getLength(); ++i) {
            Node child = lstChilds.item(i);
            if (child.getNodeType() != 1) continue;
            SVGSupport.replaceColor((Element)child, stroke, fill, alphaOverwrite, replaceOpacity);
        }
    }

    private static String replaceOpacity(String sourceOpacity, Color color, int alphaOverwrite, boolean replaceOpacity) {
        if (!replaceOpacity) {
            return sourceOpacity;
        }
        if (alphaOverwrite != 255) {
            return String.valueOf((double)alphaOverwrite / 255.0);
        }
        if (color == null) {
            return null;
        }
        return String.valueOf((double)color.getAlpha() / 255.0);
    }

    private static String replaceSVGColor(Color color, String sourceColor) {
        if (color == null) {
            return sourceColor;
        }
        return String.format("rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
    }

    private static String mapCSSStyleMapToString(Map<String, String> cssStyles) {
        return cssStyles.entrySet().stream().map(pair -> (String)pair.getKey() + ":" + (String)pair.getValue()).collect(Collectors.joining(";"));
    }

    private static Map<String, String> mapCSSStyleStringToMap(String strCss) {
        Map<String, String> cssStyles = Arrays.stream(strCss.split("\\;")).map(x -> x.split("\\:", 2)).filter(x -> !SVGSupport.isVendorSpecificCSS(x[0])).collect(Collectors.toMap(x -> x[0], x -> x[1]));
        return cssStyles;
    }

    private static boolean isVendorSpecificCSS(String x) {
        return x.startsWith("-");
    }

    public static BufferedImage renderToImage(Document doc, int width, int height) {
        UserAgentAdapter agent = new UserAgentAdapter();
        BridgeContext bridgeContext = new BridgeContext((UserAgent)agent);
        GVTBuilder builder = new GVTBuilder();
        GraphicsNode graphicsNode = builder.build(bridgeContext, doc);
        Rectangle2D rect = SVGSupport.getIntBounds(SVGSupport.getBounds(bridgeContext));
        double svgwidth = rect.getWidth();
        double svgheight = rect.getHeight();
        double scalex = (double)width / svgwidth;
        double scaley = (double)height / svgheight;
        AffineTransform aff = AffineTransform.getScaleInstance(scalex, scaley);
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
        g2d.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, "Printing");
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        SVGSupport.renderToGraphics(g2d, aff, graphicsNode);
        return bufferedImage;
    }

    public static BufferedImage renderToImage(Document doc, int width) {
        UserAgentAdapter agent = new UserAgentAdapter();
        BridgeContext bridgeContext = new BridgeContext((UserAgent)agent);
        GVTBuilder builder = new GVTBuilder();
        GraphicsNode graphicsNode = builder.build(bridgeContext, doc);
        Rectangle2D rect = SVGSupport.getIntBounds(SVGSupport.getBounds(bridgeContext));
        double svgwidth = rect.getWidth();
        double svgheight = rect.getHeight();
        int height = Math.round((float)((double)width * svgheight / svgwidth));
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        double scalewidth = (double)width / svgwidth;
        AffineTransform aff = new AffineTransform();
        aff.scale(scalewidth, scalewidth);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
        g2d.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, "Printing");
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        SVGSupport.renderToGraphics(g2d, aff, graphicsNode);
        return bufferedImage;
    }

    public static BufferedImage renderToImage(Document doc) {
        UserAgentAdapter agent = new UserAgentAdapter();
        BridgeContext bridgeContext = new BridgeContext((UserAgent)agent);
        GVTBuilder builder = new GVTBuilder();
        GraphicsNode graphicsNode = builder.build(bridgeContext, doc);
        Rectangle2D rect = SVGSupport.getIntBounds(SVGSupport.getBounds(bridgeContext));
        int svgwidth = (int)rect.getWidth();
        int svgheight = (int)rect.getHeight();
        BufferedImage bufferedImage = new BufferedImage(svgwidth, svgheight, 2);
        AffineTransform aff = new AffineTransform();
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
        g2d.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, "Printing");
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        SVGSupport.renderToGraphics(g2d, aff, graphicsNode);
        return bufferedImage;
    }

    private static Rectangle2D getIntBounds(Rectangle2D rect) {
        double width = rect.getWidth();
        double height = rect.getHeight();
        double modwidth = width % 1.0;
        double modheight = height % 1.0;
        if (modwidth >= 0.5) {
            width += 1.0;
        }
        if (modheight >= 0.5) {
            height += 1.0;
        }
        width = Math.round(width);
        height = Math.round(height);
        Rectangle2D.Double newrect = new Rectangle2D.Double(0.0, 0.0, width, height);
        return newrect;
    }

    public static Rectangle2D getBounds(BridgeContext bridgeContext) {
        double width = bridgeContext.getDocumentSize().getWidth();
        double height = bridgeContext.getDocumentSize().getHeight();
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
        return rect;
    }

    public static Rectangle2D getBounds(Document doc) {
        UserAgentAdapter agent = new UserAgentAdapter();
        BridgeContext bridgeContext = new BridgeContext((UserAgent)agent);
        GVTBuilder builder = new GVTBuilder();
        builder.build(bridgeContext, doc);
        return SVGSupport.getBounds(bridgeContext);
    }

    public static Shape renderToGraphics(Graphics2D g2d, AffineTransform aff, GraphicsNode graphicsNode) {
        graphicsNode.setTransform(aff);
        graphicsNode.paint(g2d);
        Shape graphicsOutline = graphicsNode.getOutline();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Transforming node: '%s'", graphicsNode));
            LOG.debug(String.format("Transforming shape: '%s'", graphicsOutline));
        }
        return aff.createTransformedShape(graphicsOutline);
    }

    public static BufferedImage fillShapes4PrintImg(Object[] arrNode, int intWidth) {
        return SVGSupport.fillShapes4PrintImg(arrNode, intWidth, 255);
    }

    public static BufferedImage fillShapes4PrintImg(Object[] arrNode, int intWidth, int alphaOverwrite) {
        double dblWidth = Math.min(750, intWidth);
        GraphicsNode graphicsNode = (GraphicsNode)arrNode[1];
        Rectangle2D rectNode = (Rectangle2D)arrNode[0];
        double dblScWidth = dblWidth / rectNode.getWidth();
        double dblScHeight = dblWidth / rectNode.getHeight();
        double dblHeight = rectNode.getHeight() * dblScHeight;
        int dblImgSymWidth = (int)(dblWidth * 2.0);
        int dblImgSymHeight = (int)(dblHeight * 2.0);
        int diffWidth = 1500 % dblImgSymWidth;
        int diffHeight = 1500 % dblImgSymHeight;
        int intImgWidth = 1500 - diffWidth;
        int intImgHeight = 1500 - diffHeight;
        BufferedImage bimg = new BufferedImage(intImgWidth, intImgHeight, 2);
        Graphics2D g2i = (Graphics2D)bimg.getGraphics();
        Composite oldComposite = graphicsNode.getComposite();
        if (alphaOverwrite != 255) {
            g2i.setColor(new Color(255, 255, 255, alphaOverwrite));
            graphicsNode.setComposite(SVGSupport.getComposite(alphaOverwrite));
        }
        int i = 0;
        while (bimg.getWidth() > dblImgSymWidth * i) {
            int k = 0;
            while (bimg.getHeight() > dblImgSymHeight * k) {
                AffineTransform aff = new AffineTransform();
                aff.translate(dblImgSymWidth * i, dblImgSymHeight * k);
                aff.scale(dblScWidth * 2.0, dblScHeight * 2.0);
                graphicsNode.setTransform(aff);
                graphicsNode.paint(g2i);
                ++k;
            }
            ++i;
        }
        graphicsNode.setComposite(oldComposite);
        SVGSupport.adobeReaderBugFix2(bimg);
        return bimg;
    }

    private static Composite getComposite(int alphaOverwrite) {
        return AlphaComposite.getInstance(3, (float)alphaOverwrite / 255.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillShapes4Print(Graphics2D g2d, Rectangle clip, Shape[] arrshp, BufferedImage bimg) {
        if (arrshp != null && bimg != null && clip != null && g2d != null) {
            int intImgWidth = bimg.getWidth();
            int intImgHeight = bimg.getHeight();
            AffineTransform aff = g2d.getTransform();
            try {
                for (Shape shp : arrshp) {
                    if (shp instanceof GeneralPath || !shp.intersects(clip)) continue;
                    g2d.setClip(shp);
                    g2d.scale(0.5, 0.5);
                    Rectangle2D rect = shp.getBounds2D();
                    double maxWidth = clip.getWidth() * 2.0;
                    double maxHeight = clip.getHeight() * 2.0;
                    block4: for (double x = 0.0; x < rect.getWidth() * 2.0; x += (double)intImgWidth) {
                        int xvalue = (int)(rect.getMinX() * 2.0 + x);
                        if (xvalue + bimg.getWidth() < 0) continue;
                        if ((double)xvalue > maxWidth) break;
                        for (double y = 0.0; y < rect.getHeight() * 2.0; y += (double)intImgHeight) {
                            int yvalue = (int)(rect.getMinY() * 2.0 + y);
                            if (yvalue + bimg.getHeight() < 0) continue;
                            if ((double)yvalue > maxHeight) continue block4;
                            g2d.drawImage((Image)bimg, xvalue, yvalue, null);
                        }
                    }
                    g2d.setTransform(aff);
                    g2d.setClip(null);
                }
            }
            finally {
                g2d.setTransform(aff);
                g2d.setClip(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillShapesBak(Graphics2D g2d, Rectangle clip, Object[] arrNode, Shape[] arrshp, int intWidth) {
        try {
            double dblWidth = intWidth;
            double maxWidth = 0.0;
            for (Shape shp : arrshp) {
                double tmp = shp.getBounds2D().getWidth();
                if (!(maxWidth < tmp)) continue;
                maxWidth = tmp;
            }
            if ((maxWidth = Math.min(maxWidth, clip.getWidth())) / dblWidth > 160.0) {
                dblWidth = maxWidth / 160.0;
            }
            GraphicsNode graphicsNode = (GraphicsNode)arrNode[1];
            Rectangle2D rectNode = (Rectangle2D)arrNode[0];
            double dblScWidth = dblWidth / rectNode.getWidth();
            double dblScHeight = dblWidth / rectNode.getHeight();
            double dblHeight = rectNode.getHeight() * dblScHeight;
            for (Shape shp : arrshp) {
                if (!shp.intersects(clip)) continue;
                g2d.setClip(clip.x, clip.y, (int)clip.getWidth(), (int)clip.getHeight());
                g2d.clip(shp);
                Rectangle2D rect = shp.getBounds2D();
                for (double x = 0.0; x < rect.getWidth(); x += dblWidth) {
                    for (double y = 0.0; y < rect.getHeight(); y += dblWidth) {
                        double dy;
                        double dx = rect.getMinX() + x;
                        Rectangle2D.Double rectSym = new Rectangle2D.Double(dx, dy = rect.getMinY() + y, dblWidth, dblHeight);
                        if (!rectSym.intersects(clip) || !shp.intersects(rectSym)) continue;
                        AffineTransform aff = new AffineTransform();
                        aff.translate(dx, dy);
                        aff.scale(dblScWidth, dblScHeight);
                        graphicsNode.setTransform(aff);
                        graphicsNode.paint(g2d);
                    }
                }
            }
        }
        finally {
            g2d.setClip(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderToTiff(String svgURI, OutputStream outStream) throws Exception {
        try {
            TIFFTranscoder t = new TIFFTranscoder();
            TranscoderInput input = new TranscoderInput(svgURI);
            TranscoderOutput output = new TranscoderOutput(outStream);
            t.transcode(input, output);
        }
        catch (Throwable throwable) {
            try {
                outStream.close();
            }
            catch (IOException e) {
                LOG.warn(String.format("unable to close outstream for '%s': %s", svgURI, e.getMessage()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            outStream.close();
        }
        catch (IOException e) {
            LOG.warn(String.format("unable to close outstream for '%s': %s", svgURI, e.getMessage()), (Throwable)e);
        }
    }

    public static void adobeReaderBugFix2(BufferedImage bim) {
        byte[] arrColor;
        int currentColor;
        int h;
        int w;
        ByteBuffer bbuf = ByteBuffer.allocate(4);
        for (w = 0; w < bim.getWidth(); ++w) {
            for (h = 0; h < bim.getHeight(); ++h) {
                currentColor = bim.getRGB(w, h);
                bbuf.clear();
                bbuf.putInt(currentColor);
                arrColor = bbuf.array();
                if (arrColor[0] == 0 || (arrColor[0] == -1 || arrColor[0] == 255) && arrColor[1] == 0 && arrColor[2] == 0 && arrColor[3] == 0) continue;
                return;
            }
        }
        for (w = 0; w < bim.getWidth(); ++w) {
            for (h = 0; h < bim.getHeight(); ++h) {
                currentColor = bim.getRGB(w, h);
                bbuf.clear();
                bbuf.putInt(currentColor);
                arrColor = bbuf.array();
                if (arrColor[0] != -1 && arrColor[0] != 255) continue;
                arrColor[0] = -2;
                arrColor[1] = 0;
                arrColor[2] = 0;
                arrColor[3] = 0;
                bbuf.clear();
                bbuf.put(arrColor);
                bbuf.flip();
                int newColor = bbuf.getInt();
                bim.setRGB(w, h, newColor);
            }
        }
    }
}

